<?php

namespace Rcason\MqGui\Controller\Adminhtml\Mq;

class Delete extends \Rcason\MqGui\Controller\Adminhtml\Mq
{

    protected $_aclResource = "message_queue_view";
    protected $resultPageFactory;
    protected $logger;
    protected $queueMessageRepository;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Psr\Log\LoggerInterface $logger,
        \Rcason\MqMysql\Api\QueueMessageRepositoryInterface $queueMessageRepository
    ) {
        $this->logger = $logger;
        $this->queueMessageRepository = $queueMessageRepository;
        parent::__construct($context);
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $entityId = $this->getRequest()->getParam("entity_id");
        
        if(empty($entityId)) {
            $this->messageManager->addError(__('Can\'t find this message.'));
            return $resultRedirect->setPath('*/mq/listing');
        }
        
        try {
            $message = $this->queueMessageRepository->get($entityId);
            $this->queueMessageRepository->remove($message);
            
            $this->messageManager->addSuccess(__("Message {$entityId} deleted correctly."));
            $this->logger->info("Can't delete {$entityId} message.");
            return $resultRedirect->setPath('*/mq/listing');        
        } catch (\Exception $ex) {
            $this->logger->info("Can't delete {$entityId} message.");
            $this->logger->critical($ex->getMessage());            
            $this->messageManager->addError(__("Can't delete {$entityId} message."));
            return $resultRedirect->setPath('*/mq/listing');
        }        
        
    }

}
