<?php

/**
 *
 * @Author              Ngo Quang Cuong <bestearnmoney87@gmail.com>
 * @Date                2016-12-23 18:31:24
 * @Last modified by:   nquangcuong
 * @Last Modified time: 2017-01-05 09:24:09
 */

namespace PHPCuong\Faq\Setup;

use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use PHPCuong\Faq\Model\ResourceModel\Faq as FAQ;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Install Data
 */
class InstallData implements InstallDataInterface
{
    /**
     * @var Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * Construct
     *
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->_storeManager = $storeManager;
    }

    /**
     * {@inheritdoc}
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $setup->startSetup();

        $value = [
            'entity_type' => 'faq-faq',
            'entity_id' => '1',
            'request_path' => FAQ::FAQ_REQUEST_PATH,
            'target_path' => FAQ::FAQ_TARGET_PATH,
            'is_autogenerated' => '1'
        ];

        $stores = $this->_storeManager->getStores(true, true);
        foreach ($stores as $store) {
            if ($store->getData()['store_id'] > 0) {
                $value['store_id'] = $store->getData()['store_id'];
                $setup->getConnection()->insertOnDuplicate(
                    $setup->getTable('url_rewrite'),
                    $value
                );
            }
        }
    }
}
