<?php

/**
 * Description of Magento
 * @date 26-mar-2018 16.53.36
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

namespace Installer;

use Composer\Script\Event;
use Composer\IO\IOInterface;
use mysql_xdevapi\Exception;
use Symfony\Component\Yaml\Yaml;
use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;

class Magento {
    
    public static function symlinks(Event $event) {
    	$rootDir = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
        $vendorDir = $rootDir . 'vendor' . DIRECTORY_SEPARATOR;
        $magentoDir = $rootDir . 'v1.0.0' . DIRECTORY_SEPARATOR;
        
        $symlinks = array(
            $rootDir . 'composer.json' => $magentoDir . 'composer.json',
            $rootDir . 'composer.lock' => $magentoDir . 'composer.lock',
            $magentoDir => $rootDir . 'httpdocs'
        );
        
        foreach($symlinks as $source => $target) {
            
            if(!file_exists($source)) {
                echo "\n" . "Can't create symlink because file: {$source} not exist.";
                continue;
            }

            if(is_link($target)) {
                continue;
            }

            if(is_dir($target)) {
                self::deleteDirectory($target);
            }

            symlink($source, $target);
        }
    }

    private static function deleteDirectory($dir) {
        if (!file_exists($dir)) {
            return true;
        }

        if (!is_dir($dir)) {
            return unlink($dir);
        }

        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') {
                continue;
            }

            if (!self::deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
                return false;
            }
        }

        return rmdir($dir);
    }
    
    public static function preventRunningComposerInMagentoFolder(Event $event) {
        //TODO
    }
    
    public static function validateAnswer($arg) {
        if (in_array($arg, ['Y', 'y', 'Yes', 'yes'])):
            return $arg;
        endif;
        exit('Exiting for the user\'s choice.');
    }
    public static function waitForEnter() {
        return true;
    }
    
    public static function installMagento(Event $event) {
    	$rootDir = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
        $vendorDir = $rootDir . 'vendor' . DIRECTORY_SEPARATOR;
        $magentoDir = $rootDir . 'v1.0.0' . DIRECTORY_SEPARATOR;

        //Installation data from yaml
        if(class_exists('Symfony\Component\Yaml\Yaml')):
            if(!file_exists($magentoDir . "/app/etc/env.php")):
                
                $io = $event->getIO();
                $io->write("Before install Magento copy installer/data-sample.yaml to installer/ data.yaml and insert your configurations.", true, 1);
                $io->askAndValidate("Are you sure you want to install Magento now? (yes/no): ", 'Installer\Magento::validateAnswer', 1, false);

                if(!file_exists(__DIR__ . '/data.yaml')):
                    $io->askAndValidate("Configuration file is missing. Copy data-sample.yaml to data.yaml and insert your configurations.", 'Installer\Magento::waitForEnter', 1, false);
                endif;
                
                $yml = Yaml::parse(file_get_contents(__DIR__ . '/data.yaml'));
                
                $command = self::getInstallCommand($yml['parameters']);
                self::executeCommand($command);
            else:
                throw new \Exception("\nSKIPPED: env.php already exists. Magento is already installed.");
            endif;
        else:
            throw new \Exception("\nSKIPPED: YAML Class doen't exist. Are you on windows?");
        endif;
    }
    
    private static function getInstallCommand(array $parameters) {
        $arguments = array();
        foreach ($parameters as $key => $value) {
            $arguments[] = sprintf('--%s=%s', $key, $value);
        }
        $arguments = implode(' ', $arguments);
        return sprintf('v1.0.0/bin/magento setup:install %s', $arguments);
    }
    
    protected static function executeCommand($command) {
        if(class_exists('Symfony\Component\Process\Process')):
            $process = new Process($command);
            $process->setTimeout(300);
            $process->run(
                function ($type, $buffer) { 
                    echo $buffer; 
            });
            if (!$process->isSuccessful()):
                throw new ProcessFailedException($process);
            endif;
            
            echo $process->getOutput();
        endif;
    }

    /**
     * Automaticcaly uncomment ini_set(display_errors,1) and default timezone set to take value from PHP
     */
    public static function modifyBootstrap() {
        $rootDir = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
        $magentoDir = $rootDir . 'v1.0.0' . DIRECTORY_SEPARATOR;
        $bootstrapData = file_get_contents($magentoDir . 'app/bootstrap.php');
        $bootstrapData = str_replace('#ini_set(', 'ini_set(', $bootstrapData);
        $bootstrapData = str_replace('\'UTC\'', 'ini_get(\'date.timezone\')', $bootstrapData);
        file_put_contents($magentoDir . 'app/bootstrap.php', $bootstrapData);
        echo PHP_EOL . "Successfully patched file app/bootstrap.php" . PHP_EOL;
    }
    
}
