define(
    [
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/model/quote',
        'mage/url'
    ],
    function (Component, quote, url) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'Cooder_Sia/payment/sia'
            },
            redirectAfterPlaceOrder: false,
            afterPlaceOrder: function () {
                window.location.replace(
                    url.build('sia/redirect/index')
                );
            },
            getLogoSrc: function () {
                return window.checkoutConfig.payment.siaPay.logoSrc;
            },
            hasLogo: function () {
                return window.checkoutConfig.payment.siaPay.hasLogo;
            }
        });
    }
);