<?php

namespace Cooder\Sia\Setup;

/**
 * Classe per installazione database per modulo \Cooder\Sia 
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{
    
    /**
     * (non-PHPdoc)
     * @see \Magento\Framework\Setup\InstallSchemaInterface::install()
     */
    public function install(\Magento\Framework\Setup\SchemaSetupInterface $setup, \Magento\Framework\Setup\ModuleContextInterface $context)
    {
        // Start Setup
        $installer = $setup;
        $installer->startSetup();
        
        // Eseguo drop delle tabelle se esistenti
        if ($installer->tableExists('sia_payment_transaction')) {
            $installer->getConnection()->dropTable('sia_payment_transaction');
        }
        if ($installer->tableExists('sia_sync_transaction')) {
            $installer->getConnection()->dropTable('sia_sync_transaction');
        }
        
        /**
         * Create table 'sia_payment_transaction'
         */
        $tableName = $installer->getTable('sia_payment_transaction');
        $tableComment = 'Tabella per la memorizzazione delle transazioni di pagamenti sia';
        $columns = array(
            'id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                'size' => null,
                'options' => array('identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true),
                'comment' => 'Id',
            ),
            'auth_order_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => null,
                'options' => array('nullable' => false),
                'comment' => 'Auth Order Id',
            ),
            'customer' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => false),
                'comment' => 'Customer',
            ),
            'customer_email' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => false),
                'comment' => 'Customer Email',
            ),
            'shop_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => false),
                'comment' => 'Shop Id',
            ),
            'auth_transaction_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => false),
                'comment' => 'Authorization transaction id',
            ),
            'auth_authorization_number' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => false),
                'comment' => 'Auth Authorization number',
            ),
            'auth_network' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => false),
                'comment' => 'Authorization network',
            ),
            'auth_transaction_amount' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                'size' => '10,2',
                'options' => array('nullable' => false),
                'comment' => 'Auth Transaction Amount',
            ),
            'auth_authorized_amount' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                'size' => '10,2',
                'options' => array('nullable' => false),
                'comment' => 'Auth Authorized Amount',
            ),
            'auth_currency' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => false),
                'comment' => 'Currency',
            ),
            'auth_transaction_result' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => false),
                'comment' => 'Auth Transaction Result',
            ),
            'auth_accounting_mode' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => false),
                'comment' => 'Auth Accounting Mode',
            ),
            'auth_author_mode' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => false),
                'comment' => 'Auth Author Mode',
            ),
            'auth_payment_type' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Authorization payment_type',
            ),
            'auth_exponent' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Exponent',
            ),
            'auth_accounted_amount' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                'size' => '10,2',
                'options' => array('nullable' => true),
                'comment' => 'Auth Accounted Amount',
            ),
            'auth_refunded_amount' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                'size' => '10,2',
                'options' => array('nullable' => true),
                'comment' => 'Auth Refunded Amount',
            ),
            'auth_timestamp' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                'size' => null,
                'options' => array('nullable' => true),
                'comment' => 'Auth timestamp',
            ),
            'auth_acquirer_bin' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => true),
                'comment' => 'Auth Acquirer Bin',
            ),
            'auth_merchant_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => true),
                'comment' => 'Auth Merchant Id',
            ),
            'auth_transaction_status' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Auth Transaction Status',
            ),
            'auth_response_code_iso' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Auth Response Code Iso',
            ),
            'auth_pan_tail' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Auth Pan Tail',
            ),
            'auth_pan_tail_expiry_date' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Auth Pan Tail Expiry Date',
            ),
            'auth_payment_type_pp' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Auth Payment Type PP',
            ),
            'auth_rrn' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => true),
                'comment' => 'Auth Rrn',
            ),
            'auth_card_type' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Auth Card Type',
            ),
            'transaction_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 100,
                'options' => array('nullable' => true),
                'comment' => 'Transaction Id',
            ),
            'timestamp_req' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                'size' => null,
                'options' => array('nullable' => true),
                'comment' => 'Timesamp request',
            ),
            'timestamp_elab' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                'size' => null,
                'options' => array('nullable' => true),
                'comment' => 'Timestamp Elaboration',
            ),
            'src_type' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Src Type',
            ),
            'amount' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                'size' => '10,2',
                'options' => array('nullable' => true),
                'comment' => 'Amount',
            ),
            'result' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Result',
            ),
            'status' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => true),
                'comment' => 'Status',
            ),
        );
        
        // Table creation
        $table = $installer->getConnection()->newTable($tableName);
        
        // Columns creation
        foreach($columns AS $name => $values){
            $table->addColumn(
                $name,
                $values['type'],
                $values['size'],
                $values['options'],
                $values['comment']
            );
        }
        
        // Table comment
        $table->setComment($tableComment);
        
        // Execute SQL to create the table
        $installer->getConnection()->createTable($table);
        
        /* ---------------------------------- */
        
        /**
         * Create table 'sia_sync_transaction'
         */
        $tableName = $installer->getTable('sia_sync_transaction');
        $tableComment = 'Tabella per la memorizzazione delle sincronizzazioni delle transazioni sia';
        $columns = array(
            'id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                'size' => null,
                'options' => array('identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true),
                'comment' => 'Id',
            ),
            'start_date' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 20,
                'options' => array('nullable' => false),
                'comment' => 'Start Date',
            ),
            'end_date' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 20,
                'options' => array('nullable' => false),
                'comment' => 'End Date',
            ),
            'endpoint' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 200,
                'options' => array('nullable' => false),
                'comment' => 'Endpoint',
            ),
            'shop_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 20,
                'options' => array('nullable' => false),
                'comment' => 'Shop Id',
            ),
            'operator_id' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 20,
                'options' => array('nullable' => false),
                'comment' => 'Operator Id',
            ),
            'mac_api_key' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => null,
                'options' => array('nullable' => false),
                'comment' => 'Mac Api Key',
            ),
            'hash' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 10,
                'options' => array('nullable' => false),
                'comment' => 'Hash',
            ),
            'debug' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                'size' => null,
                'options' => array('nullable' => false, 'default' => false),
                'comment' => 'Debug',
            ),
            'status' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                'size' => null,
                'options' => array('nullable' => false, 'default' => false),
                'comment' => 'Stato sync',
            ),
            'error_desc' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'size' => 200,
                'options' => array('nullable' => false, 'default' => false),
                'comment' => 'Error description',
            ),
            'updated_time' => array(
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                'size' => null,
                'options' => array('nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE),
                'comment' => 'Updated time',
            )
        );
        
        // Table creation
        $table = $installer->getConnection()->newTable($tableName);
        
        // Columns creation
        foreach($columns AS $name => $values){
            $table->addColumn(
                $name,
                $values['type'],
                $values['size'],
                $values['options'],
                $values['comment']
            );
        }
        
        // Table comment
        $table->setComment($tableComment);
        
        // Execute SQL to create the table
        $installer->getConnection()->createTable($table);
    }
    
}