<?php

namespace Cooder\Sia\Model\Webservice\AuthorizationList;

/**
 * Oggetto per la gestione della risposta sulla singola autorizzazione
 * nella richiesta di informazioni su una lista di autorizzazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class ResponseItem
{
    
    /**
     * type of payment allowed
     * 
     * @var string
     */
    protected $_paymentType;
    
    /**
     * type of authorization granted
     * 
     * @var string
     */
    protected $_authorizationType;
    
    /**
     * the transaction identifier assigned by @POS
     * 
     * @var string
     */
    protected $_transactionId;
    
    /**
     * network code
     * 
     * @var string
     */
    protected $_network;
    
    /**
     * order code
     * 
     * @var string
     */
    protected $_orderId;
    
    /**
     * amount of transaction in Eur cents
     * 
     * @var int
     */
    protected $_transactionAmount;
    
    /**
     * authorized amount in Eur cents
     * 
     * @var int
     */
    protected $_authorizedAmount;
    
    /**
     * currency ISO code
     * 
     * @var string
     */
    protected $_currency;
    
    /**
     * number of decimals for the currency
     * 
     * @var string
     */
    protected $_exponent;
    
    /**
     * the accounted amount in Eur cents
     * 
     * @var int
     */
    protected $_accountedAmount;
    
    /**
     * the refunfed amount in Eur cents 
     * 
     * @var int
     */
    protected $_refundedAmount;
    
    /**
     * outcome of transaction
     * 
     * @var string
     */
    protected $_transactionResult;
    
    /**
     * date and time of transaction in yyyy-mm-ggTHH:mm:ss format
     * 
     * @var string
     */
    protected $_timestamp;
    
    /**
     *  authorization code (filled in in case of positive outcome). 
     *  This is a string having a maximum length of 6 characters for all circuits excluding MyBank; 
     *  the latter, on the other hand, has a fixed length of 35 characters and contains the transaction identifier assigned 
     *  by the Validation Service. 
     *  It is not relevant if the transaction is performed using the Paypal circuit
     * 
     * @var string
     */
    protected $_authorizationNumber;
    
    /**
     * acquirerbin. Acquirer’s International identification code
     * 
     * @var string
     */
    protected $_acquirerBin;
    
    /**
     * the merchant’s code assigned by acquirer
     * 
     * @var string
     */
    protected $_merchantId;
    
    /**
     * current status of the authorization
     * 
     * @var string
     */
    protected $_transactionStatus;
    
    /**
     * Information present only for the sections Authorization in response to an authorization
     * message (Online, Deferred or VBV Authorization) and for stores adhering to the "SV53
     * - Provide ResponseCodeISO in authorizations with APIs" service. It contains the
     * outcome code received from the relevant circuit.
     * 
     * @var string
     */
    protected $_responseCodeIso;
    
    /**
     * last four digit of the card number (only if the shop is SV64 enabled)
     * 
     * @var string
     */
    protected $_panTail;
    
    /**
     * expiry date of the card (only if the shop is SV64 enabled)
     * 
     * @var string
     */
    protected $_panExpiryDate;
    
    /**
     * "2" for PagaConPostepay transactions by Wallet; “4” for PagaConPostepay
     * transactions by Card; “0” otherwise (only if the shop is SV73 enabled)
     * 
     * @var string
     */
    protected $_paymentTypePP;
    
    /**
     *  unique identifier of the transaction in the iso authorization message 
     *  (only if the shop is SV71 enabled)
     * 
     * @var string
     */
    protected $_rrn;
    
    /**
     * C for Credit; D for Debit; P for prepaid (only if the shop is SV82 enabled and the
     * information is available)
     * 
     * @var string
     */
    protected $_cartType;
    
    /**
     * Message authentication code
     * 
     * @var string
     */
    protected $_mac;
    
    /**
     * Set "PaymentType" value
     * 
     * @param string $value
     */
    public function setPaymentType($value)
    {
        $this->_paymentType = $value;
    }
    
    /**
     * Get "PaymentType" value
     * 
     * @return string
     */
    public function getPaymentType()
    {
        return $this->_paymentType;
    }
    
    /**
     * Set "AuthorizationType" value
     *
     * @param string $value
     */
    public function setAuthorizationType($value)
    {
        $this->_authorizationType = $value;
    }
    
    /**
     * Get "AuthorizationType" value
     *
     * @return string
     */
    public function getAuthorizationType()
    {
        return $this->_authorizationType;
    }
    
    /**
     * Set "TransactionId" value
     *
     * @param string $value
     */
    public function setTransactionId($value)
    {
        $this->_transactionId = $value;
    }
    
    /**
     * Get "TransactionId" value
     *
     * @return string
     */
    public function getTransactionId()
    {
        return $this->_transactionId;
    }
    
    /**
     * Set "Network" value 
     *
     * @param string $value
     */
    public function setNetwork($value)
    {
        $this->_network = $value;
    }
    
    /**
     * Get "Network" value
     *
     * @return string
     */
    public function getNetwork()
    {
        return $this->_network;
    }
    
    /**
     * Set "OrderId" value
     *
     * @param string $value
     */
    public function setOrderId($value)
    {
        $this->_orderId = $value;
    }
    
    /**
     * Get "OrderId" value
     *
     * @return string
     */
    public function getOrderId()
    {
        return $this->_orderId;
    }
    
    /**
     * Set "TransactionAmount" value
     *
     * @param int $value
     */
    public function setTransactionAmount($value)
    {
        $this->_transactionAmount = $value;
    }
    
    /**
     * Get "TransactionAmount" value
     *
     * @return int
     */
    public function getTransactionAmount()
    {
        return $this->_transactionAmount;
    }
    
    /**
     * Set "AuthorizedAmount" value
     *
     * @param int $value
     */
    public function setAuthorizedAmount($value)
    {
        $this->_authorizedAmount = $value;
    }
    
    /**
     * Get "AuthorizedAmount" value
     *
     * @return int
     */
    public function getAuthorizedAmount()
    {
        return $this->_authorizedAmount;
    }
    
    /**
     * Set "Currency" value
     *
     * @param string $value
     */
    public function setCurrency($value)
    {
        $this->_currency = $value;
    }
    
    /**
     * Get "Currency" value
     *
     * @return string
     */
    public function getCurrency()
    {
        return $this->_currency;
    }
    
    /**
     * Set "Exponent" value
     *
     * @param string $value
     */
    public function setExponent($value)
    {
        $this->_exponent = $value;
    }
    
    /**
     * Get "Exponent" value
     *
     * @return string
     */
    public function getExponent()
    {
        return $this->_exponent;
    }
    
    /**
     * Set "AccountedAmount" value
     *
     * @param int $value
     */
    public function setAccountedAmount($value)
    {
        $this->_accountedAmount = $value;
    }
    
    /**
     * Get "AccountedAmount" value
     *
     * @return int
     */
    public function getAccountedAmount()
    {
        return $this->_accountedAmount;
    }
    
    /**
     * Set "RefundedAmount" value
     *
     * @param int $value
     */
    public function setRefundedAmount($value)
    {
        $this->_refundedAmount = $value;
    }
    
    /**
     * Get "RefundedAmount" value
     *
     * @return int
     */
    public function getRefundedAmount()
    {
        return $this->_refundedAmount;
    }
    
    /**
     * Set "TransactionResult" value
     *
     * @param string $value
     */
    public function setTransactionResult($value)
    {
        $this->_transactionResult = $value;
    }
    
    /**
     * Get "TransactionResult" value
     *
     * @return string
     */
    public function getTransactionResult()
    {
        return $this->_transactionResult;
    }
    
    /**
     * Set "Timestamp" value
     *
     * @param string $value
     */
    public function setTimestamp($value)
    {
        $this->_timestamp = $value;
    }
    
    /**
     * Get "Timestamp" value
     *
     * @return string
     */
    public function getTimestamp()
    {
        return $this->_timestamp;
    }
    
    /**
     * Set "AuthorizationNumber" value
     *
     * @param string $value
     */
    public function setAuthorizationNumber($value)
    {
        $this->_authorizationNumber = $value;
    }
    
    /**
     * Get "AuthorizationNumber" value
     *
     * @return string
     */
    public function getAuthorizationNumber()
    {
        return $this->_authorizationNumber;
    }
    
    /**
     * Set "AcquirerBin" value
     *
     * @param string $value
     */
    public function setAcquirerBin($value)
    {
        $this->_acquirerBin = $value;
    }
    
    /**
     * Get "AcquirerBin" value
     *
     * @return string
     */
    public function getAcquirerBin()
    {
        return $this->_acquirerBin;
    }
    
    /**
     * Set "MerchantId" value
     *
     * @param string $value
     */
    public function setMerchantId($value)
    {
        $this->_merchantId = $value;
    }
    
    /**
     * Get "MerchantId" value
     *
     * @return string
     */
    public function getMerchantId()
    {
        return $this->_merchantId;
    }
    
    /**
     * Set "TransactionStatus" value
     *
     * @param string $value
     */
    public function setTransactionStatus($value)
    {
        $this->_transactionStatus = $value;
    }
    
    /**
     * Get "TransactionStatus" value
     *
     * @return string
     */
    public function getTransactionStatus()
    {
        return $this->_transactionStatus;
    }
    
    /**
     * Set "ResponseCodeIso" value
     *
     * @param string $value
     */
    public function setResponseCodeIso($value)
    {
        $this->_responseCodeIso = $value;
    }
    
    /**
     * Get "ResponseCodeIso" value
     *
     * @return string
     */
    public function getResponseCodeIso()
    {
        return $this->_responseCodeIso;
    }
    
    /**
     * Set "PanTail" value
     *
     * @param string $value
     */
    public function setPanTail($value)
    {
        $this->_panTail = $value;
    }
    
    /**
     * Get "PanTail" value
     *
     * @return string
     */
    public function getPanTail()
    {
        return $this->_panTail;
    }
    
    /**
     * Set "PanExpiryDate" value
     *
     * @param string $value
     */
    public function setPanExpiryDate($value)
    {
        $this->_panExpiryDate = $value;
    }
    
    /**
     * Get "PanExpiryDate" value
     *
     * @return string
     */
    public function getPanExpiryDate()
    {
        return $this->_panExpiryDate;
    }
    
    /**
     * Set "PaymentTypePP" value
     *
     * @param string $value
     */
    public function setPaymentTypePP($value)
    {
        $this->_paymentTypePP = $value;
    }
    
    /**
     * Get "PaymentTypePP" value
     *
     * @return string
     */
    public function getPaymentTypePP()
    {
        return $this->_paymentTypePP;
    }
    
    /**
     * Set "Rrn" value
     *
     * @param string $value
     */
    public function setRrn($value)
    {
        $this->_rrn = $value;
    }
    
    /**
     * Get "Rrn" value
     *
     * @return string
     */
    public function getRrn()
    {
        return $this->_rrn;
    }
    
    /**
     * Set "CardType" value
     *
     * @param string $value
     */
    public function setCardType($value)
    {
        $this->_cartType = $value;
    }
    
    /**
     * Get "CardType" value
     *
     * @return string
     */
    public function getCardType()
    {
        return $this->_cartType;
    }
    
    /**
     * Set "Mac" value
     *
     * @param string $value
     */
    public function setMac($value)
    {
        $this->_mac = $value;
    }
    
    /**
     * Get "Mac" value
     *
     * @return string
     */
    public function getMac()
    {
        return $this->_mac;
    }
}