<?php

namespace Cooder\Sia\Model\Webservice\AuthorizationList;

/**
 * Oggetto per la gestione della risposta alla richiesta er il recupero delle informazioni
 * sulle autorizzazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Response
{
    
    /**
     * Risultato della chiamata
     *
     * @var string
     */
    protected $_result;
    
    /**
     * Numero di item della response
     * 
     * @var int
     */
    protected $_numberOfItems;
    
    /**
     * Items
     * 
     * @var Array<\Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem>
     */
    protected $_items = [];
    
    
    /**
     * Imposta il valore per il campo Result
     *
     * @param string $value
     */
    public function setResult($value)
    {
        $this->_result = $value;
    }
    
    /**
     * Ritorna il risultato della chiamata
     *
     * @return string
     */
    public function getResult()
    {
        return $this->_result;
    }
    
    /**
     * Imposta il valore per il campo NumberOfItems
     *
     * @param string $value
     */
    public function setNumberOfItems($value)
    {
        $this->_numberOfItems = $value;
    }
    
    /**
     * Ritorna il valore per il campo NumberOfItems
     *
     * @return string
     */
    public function getNumberOfItems()
    {
        return $this->_numberOfItems;
    }
    
    /**
     * Aggiunge un item
     * 
     * @param \Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem $value
     */
    public function addItem($value)
    {
        $this->_items[] = $value;
    }
    
    /**
     * Ritorna la lista di item
     * 
     * @return Array<\Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem>
     */
    public function getItems()
    {
        return $this->_items;
    }
    
    /**
     * Esegue il reset dei campi
     */
    public function reset()
    {
        $this->_result = null;
        $this->_numberOfItems = null;
        $this->_items = [];
    }
    
    /**
     * Ritorna la descrizione dell'errore
     *
     * @return string
     */
    public function getErrorDesc()
    {
        switch($this->getResult()) {
            case '02': {
                return __('ReqRefNum duplicated or incorrect');
                break;
            }
            case '03': {
                return __('Incorrect message format, missing or incorrect field');
                break;
            }
            case '04': {
                return __('Incorrect API authentication, incorrect MAC');
                break;
            }
            case '05': {
                return __('Incorrect date, or period indicated empty');
                break;
            }
            case '06': {
                return __('Unforeseen error during processing of request');
                break;
            }
            case '07': {
                return __('TransactionID not found');
                break;
            }
            case '40': {
                return __('Empty xml or missing ‘data’ parameter');
                break;
            }
            case '41': {
                return __('Xml not parsable');
                break;
            }
        }
    }
}