<?php

namespace Cooder\Sia\Model;

/**
 * ConfigProvider per il metodo di pagamento SiaPay
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class SiaPayConfigProvider implements \Magento\Checkout\Model\ConfigProviderInterface
{
    
    /**
	 * Oggetto per il recupero dei dati dalla configurazione
	 *
	 * @var \Magento\Framework\App\Config\ScopeConfigInterface
	 */
	protected $_scopeConfig;
	
	/**
	 * Store Manager
	 * 
	 * @var \Magento\Store\Model\StoreManagerInterface
	 */
	protected $_storeManager;
	
	/**
	 * Asset Repository
	 * 
	 * @var \Magento\Framework\View\Asset\Repository
	 */
	protected $_assetRepository;
    
	/**
	 * Costruttore
	 * 
	 * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
	 * @param \Magento\Store\Model\StoreManagerInterface $storeManager
	 * @param \Magento\Framework\View\Asset\Repository $assetRepository
	 */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\View\Asset\Repository $assetRepository
    )
    {
        $this->_scopeConfig = $scopeConfig;
        $this->_storeManager = $storeManager;
        $this->_assetRepository = $assetRepository;
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Checkout\Model\ConfigProviderInterface::getConfig()
     */
    public function getConfig()
    {
        $logoPath = $this->_assetRepository->getUrl("Cooder_Sia::images/loghi_pagamento.png");
        
        $config = [
            'payment' => [
                'siaPay' => [
                    'hasLogo' => !empty($logoPath),
                    'logoSrc' => $logoPath
                 ]
            ]
        ];
        
        return $config;
    }
}