<?php

namespace Cooder\Sia\Model\Export;

/**
 * Override per classe \Magento\Ui\Model\Export\MetadataProvider
 * 
 * @author Devid Marcantoni <devid@cooder>
 */
class MetadataProvider extends \Magento\Ui\Model\Export\MetadataProvider
{
    
    /**
     * Source per Authorization Mode
     * 
     * @var \Cooder\Sia\Model\Config\Source\Authorization\Mode
     */
    protected $_sourceAuthorizationMode;
    
    /**
     * Source per Authorization Network
     *
     * @var \Cooder\Sia\Model\Config\Source\Authorization\Network
     */
    protected $_sourceAuthorizationNetwork;
    
    /**
     * Source per Authorization Payment Type
     *
     * @var \Cooder\Sia\Model\Config\Source\Authorization\PaymentType
     */
    protected $_sourceAuthorizationPaymentType;
    
    /**
     * Source per Authorization Transaction Result
     *
     * @var \Cooder\Sia\Model\Config\Source\Authorization\TransactionResult
     */
    protected $_sourceAuthorizationTransactionResult;
    
    /**
     * Source per Authorization Transaction Status
     *
     * @var \Cooder\Sia\Model\Config\Source\Authorization\TransactionStatus
     */
    protected $_sourceAuthorizationTransactionStatus;

    /**
     * Source per Transaction Result
     *
     * @var \Cooder\Sia\Model\Config\Source\Transaction\Result
     */
    protected $_sourceTransactionResult;
    
    /**
     * Source per Transaction Source Type
     *
     * @var \Cooder\Sia\Model\Config\Source\Transaction\SrcType
     */
    protected $_sourceTransactionSrcType;
    
    /**
     * Source per Transaction Status
     *
     * @var \Cooder\Sia\Model\Config\Source\Transaction\Status
     */
    protected $_sourceTransactionStatus;
    
    /**
     * Costurttore
     * 
     * @param \Cooder\Sia\Model\Config\Source\Authorization\Mode $sourceAuthorizationMode
     * @param \Cooder\Sia\Model\Config\Source\Authorization\Network $sourceAuthorizationNetwork
     * @param \Cooder\Sia\Model\Config\Source\Authorization\PaymentType $sourceAuthorizationPaymentType
     * @param \Cooder\Sia\Model\Config\Source\Authorization\TransactionStatus $sourceAuthorizationTransactionStatus
     * @param \Cooder\Sia\Model\Config\Source\Authorization\TransactionResult $sourceAuthorizationTransactionResult
     * @param \Cooder\Sia\Model\Config\Source\Transaction\Result $sourceTransactionResult
     * @param \Cooder\Sia\Model\Config\Source\Transaction\SrcType $sourceTransactionSrcType
     * @param \Cooder\Sia\Model\Config\Source\Transaction\Status $sourceTransactionStatus
     * @param \Magento\Ui\Component\MassAction\Filter $filter
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $localeDate
     * @param \Magento\Framework\Locale\ResolverInterface $localeResolver
     * @param string $dateFormat
     * @param array $data
     */
    public function __construct(
        \Cooder\Sia\Model\Config\Source\Authorization\Mode $sourceAuthorizationMode,
        \Cooder\Sia\Model\Config\Source\Authorization\Network $sourceAuthorizationNetwork,
        \Cooder\Sia\Model\Config\Source\Authorization\PaymentType $sourceAuthorizationPaymentType,
        \Cooder\Sia\Model\Config\Source\Authorization\TransactionStatus $sourceAuthorizationTransactionStatus,
        \Cooder\Sia\Model\Config\Source\Authorization\TransactionResult $sourceAuthorizationTransactionResult,
        \Cooder\Sia\Model\Config\Source\Transaction\Result $sourceTransactionResult,
        \Cooder\Sia\Model\Config\Source\Transaction\SrcType $sourceTransactionSrcType,
        \Cooder\Sia\Model\Config\Source\Transaction\Status $sourceTransactionStatus,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $localeDate,
        \Magento\Framework\Locale\ResolverInterface $localeResolver,
        $dateFormat = 'M j, Y H:i:s A',
        array $data = []
    )
    {
        parent::__construct($filter, $localeDate, $localeResolver, $dateFormat, $data);    
        $this->_sourceAuthorizationMode = $sourceAuthorizationMode;
        $this->_sourceAuthorizationNetwork = $sourceAuthorizationNetwork;
        $this->_sourceAuthorizationPaymentType = $sourceAuthorizationPaymentType;
        $this->_sourceAuthorizationTransactionResult = $sourceAuthorizationTransactionResult;
        $this->_sourceAuthorizationTransactionStatus = $sourceAuthorizationTransactionStatus;
        $this->_sourceTransactionResult = $sourceTransactionResult;
        $this->_sourceTransactionSrcType = $sourceTransactionSrcType;
        $this->_sourceTransactionStatus = $sourceTransactionStatus;
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Ui\Model\Export\MetadataProvider::getOptions()
     */
    public function getOptions()
    {
        $options = parent::getOptions();
        
        $component = $this->filter->getComponent();
        if($component->getName() == 'sia_transactions_listing') {
            $options['auth_accounting_mode'] = $this->_sourceAuthorizationMode->toArray();  
            $options['auth_author_mode'] = $this->_sourceAuthorizationMode->toArray();  
            $options['auth_network'] = $this->_sourceAuthorizationNetwork->toArray();  
            $options['auth_payment_type'] = $this->_sourceAuthorizationPaymentType->toArray();  
            $options['auth_transaction_result'] = $this->_sourceAuthorizationTransactionResult->toArray();  
            $options['auth_transaction_status'] = $this->_sourceAuthorizationTransactionStatus->toArray();  
            $options['result'] = $this->_sourceTransactionResult->toArray();  
            $options['src_type'] = $this->_sourceTransactionSrcType->toArray();  
            $options['status'] = $this->_sourceTransactionStatus->toArray();  
        }
        
        return $options;
    }
    
}