<?php

namespace Cooder\Sia\Model\Config\Source;

/**
 * Source per parametro boolean
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class YesNo implements \Magento\Framework\Option\ArrayInterface
{
    
    const YES = 1;
    const NO = 0;
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::YES, 'label' => __('Si')], 
            ['value' => self::NO, 'label' => __('No')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [self::YES => __('Si'), self::NO => __('No')];
    }
}