<?php

namespace Cooder\Sia\Model\Config\Source\Transaction;

/**
 * Source per il source type delle transazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class SrcType implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '01', 'label' => __('Reversal of authorization')], 
            ['value' => '02', 'label' => __('Credit transaction')], 
            ['value' => '03', 'label' => __('Cancellation of booking')], 
            ['value' => '04', 'label' => __('Booking transaction')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '01' => __('Reversal of authorization'),
            '02' => __('Credit transaction'),
            '03' => __('Cancellation of booking'),
            '04' => __('Booking transaction'),
        ];
    }
}