<?php

namespace Cooder\Sia\Model\Config\Source\Transaction;

/**
 * Source per il result delle transazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Result implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '00', 'label' => __('Success')], 
            ['value' => '01', 'label' => __('Expired time-limits')], 
            ['value' => '02', 'label' => __('Denied due to problems with store registered data')], 
            ['value' => '03', 'label' => __('Denied due to communication problems with authorization circuits')],
            ['value' => '04', 'label' => __('Denied by card issuer')], 
            ['value' => '05', 'label' => __('Ceiling not restored')], 
            ['value' => '06', 'label' => __('Unexpected error during processing of request')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '00' => __('Success'),
            '01' => __('Expired time-limits'),
            '02' => __('Denied due to problems with store registered data'),
            '03' => __('Denied due to communication problems with authorization circuits'),
            '04' => __('Denied by card issuer'),
            '05' => __('Ceiling not restored'),
            '06' => __('Unexpected error during processing of request')
        ];
    }
}