<?php

namespace Cooder\Sia\Model\Config\Source;

/**
 * Source per le azioni di pagamento (authorization|capture)
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class PaymentAction implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        $result = [];
        foreach ($this->toArray() as $value => $label) {
            $result[] = ['value' => $value, 'label' => $label];
        }
        return $result;
    }

    /**
     * {@inheritdoc}
     */
    public function toArray()
    {
        return [
            \Magento\Payment\Model\Method\AbstractMethod::ACTION_AUTHORIZE_CAPTURE    => __('Immediata'),
            \Magento\Payment\Model\Method\AbstractMethod::ACTION_AUTHORIZE => __('Differita')
        ];
    }
}
