<?php

namespace Cooder\Sia\Model\Config\Source\Authorization;

/**
 * Source per il payment type delle autorizzazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class PaymentType implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '03', 'label' => __('SSL')], 
            ['value' => '04', 'label' => __('VBV: merchant and consumer adhering to VBV')], 
            ['value' => '05', 'label' => __('SecureCode : merchant and consumer adhering to SecureCode')], 
            ['value' => '06', 'label' => __('Merchant VBV: merchant adhering to VBV and consumer not adhering')],
            ['value' => '07', 'label' => __('Merchant SecureCode: merchant adhering to SecureCode and consumer not adhering')], 
            ['value' => '08', 'label' => __('VBV Owner not authenticated: merchant adhering to VBV; the consumer has not authenticated himself correctly')], 
            ['value' => '09', 'label' => __('Mail order/Telephone order')],
            ['value' => '13', 'label' => __('SafeKey: merchant and consumer adhering to SafeKey')], 
            ['value' => '14', 'label' => __('SafeKey Merchant: merchant adhering to SafeKey and consumer not adhering')], 
            ['value' => '15', 'label' => __('SafeKey Owner not authenticated: merchant adhering to SafeKey; the consumer has not authenticated himself correctly')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '03' => __('SSL'),
            '04' => __('VBV: merchant and consumer adhering to VBV'),
            '05' => __('SecureCode : merchant and consumer adhering to SecureCode'),
            '06' => __('Merchant VBV: merchant adhering to VBV and consumer not adhering'),
            '07' => __('Merchant SecureCode: merchant adhering to SecureCode and consumer not adhering'),
            '08' => __('VBV Owner not authenticated: merchant adhering to VBV; the consumer has not authenticated himself correctly'),
            '09' => __('Mail order/Telephone order'),
            '13' => __('SafeKey: merchant and consumer adhering to SafeKey'),
            '14' => __('SafeKey Merchant: merchant adhering to SafeKey and consumer not adhering'),
            '15' => __('SafeKey Owner not authenticated: merchant adhering to SafeKey; the consumer has not authenticated himself correctly')
        ];
    }
}