<?php

namespace Cooder\Sia\Model\Config\Source\Authorization;

/**
 * Source per il network delle autorizzazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Network implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '01', 'label' => __('Visa')], 
            ['value' => '02', 'label' => __('Mastercard')], 
            ['value' => '04', 'label' => __('Maestro')], 
            ['value' => '06', 'label' => __('Amex')],
            ['value' => '07', 'label' => __('Diners')], 
            ['value' => '08', 'label' => __('JCB')], 
            ['value' => '09', 'label' => __('Pagobancomat')],
            ['value' => '80', 'label' => __('IBAN')], 
            ['value' => '88', 'label' => __('Token Pan Alias (only in request)')], 
            ['value' => '91', 'label' => __('Jiffy')],
            ['value' => '94', 'label' => __('Postepay')],
            ['value' => '96', 'label' => __('MyBank')], 
            ['value' => '97', 'label' => __('PayPal')], 
            ['value' => '98', 'label' => __('Pan Alias (only in requests)')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '01' => __('Visa'),
            '02' => __('Mastercard'),
            '04' => __('Maestro'),
            '06' => __('Amex'),
            '07' => __('Diners'),
            '08' => __('JCB'),
            '09' => __('Pagobancomat'),
            '80' => __('IBAN'),
            '88' => __('Token Pan Alias (only in request)'),
            '91' => __('Jiffy'),
            '94' => __('Postepay'),
            '96' => __('MyBank'),
            '97' => __('PayPal'),
            '98' => __('Pan Alias (only in requests)')
        ];
    }
}