<?php

namespace Cooder\Sia\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

/**
 * Helper per il modulo Cooder\Sia
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    
    const SCOPE_CONFIG_PATH_PREFIX = 'payment/sia/';
    
    /**
     * Store manager
     *
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;
    
    /**
     * Costruttore
     * 
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    )
    {
        parent::__construct($context);
        $this->_storeManager = $storeManager;
    }
    
    /**
     * Ritorna endpoint del server Sia
     * 
     * @return string
     */
    public function getEndpoint()
    {
        if($this->_isSandboxMode()) {
            return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'sandbox/endpoint_sandbox');
        }
        return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'production/endpoint_production');
    }
    
    /**
     * Ritorna endpoint xml del server Sia
     *
     * @return string
     */
    public function getEndpointXml()
    {
        if($this->_isSandboxMode()) {
            return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'sandbox/endpointxml_sandbox');
        }
        return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'production/endpointxml_production');
    }
    
    /**
     * Ritorna identificatore shop del venditore
     * 
     * @return string
     */
    public function getShopId()
    {
        if($this->_isSandboxMode()) {
            return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'sandbox/shop_id_sandbox');
        }
        return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'production/shop_id_production', \Magento\Store\Model\ScopeInterface::SCOPE_WEBSITE, $this->_storeManager->getWebsite()->getId());
    }
    
    /**
     * Ritorna mac redirect key
     * 
     * @return string
     */
    public function getMacRedirectKey()
    {
        if($this->_isSandboxMode()) {
            return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'sandbox/mac_redirect_key_sandbox');
        }
        return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'production/mac_redirect_key_production', \Magento\Store\Model\ScopeInterface::SCOPE_WEBSITE, $this->_storeManager->getWebsite()->getId());
    }
    
    /**
     * Ritorna mac api key
     * 
     * @return string
     */
    public function getMacApiKey()
    {
        if($this->_isSandboxMode()) {
            return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'sandbox/mac_api_key_sandbox');
        }
        return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'production/mac_api_key_production', \Magento\Store\Model\ScopeInterface::SCOPE_WEBSITE, $this->_storeManager->getWebsite()->getId());
    }
    
    /**
     * Ritorna se richiesto ambiente di sandbox
     * 
     * @return boolean
     */
    protected function _isSandboxMode()
    {
        return $this->scopeConfig->getValue(self::SCOPE_CONFIG_PATH_PREFIX . 'sandbox/environment', \Magento\Store\Model\ScopeInterface::SCOPE_WEBSITE, $this->_storeManager->getWebsite()->getId()) == \Cooder\Sia\Model\Config\Source\Environment::SANDBOX;    
    }
}