<?php

namespace Cooder\Sia\Model\Webservice\TransactionList;

/**
 * Oggetto per la gestione della risposta sulla singola transazione
 * nella richiesta di informazioni su una lista di transazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class ResponseItem
{
 
    /**
     * identifier of the transaction of the bookable transaction
     * 
     * @var string
     */
    protected $_transactionId;
    
    /**
     * date and time of request in yyyy-MM-ddTHH:mm:ss format
     * 
     * @var string
     */
    protected $_timestampReq;
    
    /**
     * date and time of processing in yyyy-MM-ddTHH:mm:ss format
     * 
     * @var string
     */
    protected $_timestampElab;
    
    /**
     * type of bookable transaction
     * 
     * @var string
     */
    protected $_srcType;
    
    /**
     * amount of booking transaction in Eur cents
     * 
     * @var int
     */
    protected $_amount;
    
    /**
     * outcome of transaction
     * 
     * @var string
     */
    protected $_result;
    
    /**
     * status of transaction
     * 
     * @var string
     */
    protected $_status;
    
    /**
     * optional description that could be associated to the accounting operation
     * 
     * @var string
     */
    protected $_opDescr;
    
    /**
     * message authentication code: signature of accounting transaction
     * 
     * @var string
     */
    protected $_mac;
    
    /**
     * authorization object
     * 
     * @var \Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem
     */
    protected $_authorization;
    
    /**
     * Set identifier of the transaction of the bookable transaction
     * 
     * @param string $value
     */
    public function setTransactionId($value)
    {
        $this->_transactionId = $value;
    }
    
    /**
     * Get identifier of the transaction of the bookable transaction
     * 
     * @return string
     */
    public function getTransactionId()
    {
        return $this->_transactionId;
    }
    
    /**
     * Set date and time of request in yyyy-MM-ddTHH:mm:ss format
     * 
     * @param string $value
     */
    public function setTimestampReq($value)
    {
        $this->_timestampReq = $value;
    }
    
    /**
     * Get date and time of request in yyyy-MM-ddTHH:mm:ss format
     * 
     * @return string
     */
    public function getTimestampReq()
    {
        return $this->_timestampReq;
    }
    
    /**
     * Set date and time of processing in yyyy-MM-ddTHH:mm:ss format
     * 
     * @param string $value
     */
    public function setTimestampElab($value)
    {
        $this->_timestampElab = $value;
    }
    
    /**
     * Get date and time of processing in yyyy-MM-ddTHH:mm:ss format
     * 
     * @return string
     */
    public function getTimestampElab()
    {
        return $this->_timestampElab;
    }
    
    /**
     * Set type of bookable transaction
     * 
     * @param string $value
     */
    public function setSrcType($value)
    {
        $this->_srcType = $value;
    }
    
    /**
     * Get type of bookable transaction
     * 
     * @return string
     */
    public function getSrcType()
    {
        return $this->_srcType;
    }
    
    /**
     * Set amount of booking transaction in Eur cents
     * 
     * @param int $value
     */
    public function setAmount($value)
    {
        $this->_amount = $value;
    }
    
    /**
     * Get amount of booking transaction in Eur cents
     * 
     * @return number
     */
    public function getAmount()
    {
        return $this->_amount;
    }
    
    /**
     * Set outcome of transaction
     * 
     * @param string $value
     */
    public function setResult($value)
    {
        $this->_result = $value;
    }
    
    /**
     * Get outcome of transaction
     * 
     * @return string
     */
    public function getResult()
    {
        return $this->_result;
    }
 
    /**
     * Set status of transaction
     * 
     * @param string $value
     */
    public function setStatus($value)
    {
        $this->_status = $value;
    }
    
    /**
     * Get status of transaction
     * 
     * @return string
     */
    public function getStatus()
    {
        return $this->_status;
    }
    
    /**
     * Set optional description that could be associated to the accounting operation
     * 
     * @param string $value
     */
    public function setOpDescr($value)
    {
        $this->_opDescr = $value;
    }
    
    /**
     * Get optional description that could be associated to the accounting operation
     * 
     * @return string
     */
    public function getOpDescr()
    {
        return $this->_opDescr;
    }
    
    /**
     * Set message authentication code: signature of accounting transaction
     *
     * @param string $value
     */
    public function setMac($value)
    {
        $this->_opDescr = $value;
    }
    
    /**
     * Get message authentication code: signature of accounting transaction
     *
     * @return string
     */
    public function getMac()
    {
        return $this->_opDescr;
    }
    
    /**
     * Set authorization object
     * 
     * @param \Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem $value
     */
    public function setAuthorization(\Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem $value)
    {
        $this->_authorization = $value;
    }
    
    /**
     * Get authorization object
     * 
     * @return \Cooder\Sia\Model\Webservice\AuthorizationList\ResponseItem
     */
    public function getAuthorization()
    {
        return $this->_authorization;
    }
}