<?php

namespace Cooder\Sia\Model\Webservice\PaymentInit;

/**
 * Oggetto per la gestione della risposta alla richiesta di link per il pagamento
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Response
{
    
    /**
     * Risultato della chiamata
     * 
     * @var string
     */
    protected $_result;
    
    /**
     * Token associato alla richiesta di pagamento
     * 
     * @var string
     */
    protected $_token;
    
    /**
     * Data di creazione link
     * 
     * @var string
     */
    protected $_creationDate;
    
    /**
     * Stato del link creato
     * 
     * @var string
     */
    protected $_status;
    
    /**
     * Data di ultimo utilizzo link
     * 
     * @var string
     */
    protected $_lastUseDate;
    
    /**
     * Data di scadenza link
     * 
     * @var string
     */
    protected $_expirationDate;
    
    /**
     * Data di revoca del link
     * 
     * @var string
     */
    protected $_revokeDate;
    
    /**
     * Identificatore ordine
     * 
     * @var string
     */
    protected $_orderId;
    
    /**
     * Mac
     * 
     * @var string
     */
    protected $_mac;
    
    /**
     * Link da utilizzare per il pagamento
     * 
     * @var string
     */
    protected $_completeLink;
    
    /**
     * Imposta il valore per il campo Result
     * 
     * @param string $value
     */
    public function setResult($value)
    {
        $this->_result = $value;
    }
    
    /**
     * Ritorna il risultato della chiamata
     * 
     * @return string
     */
    public function getResult()
    {
        return $this->_result;
    }
    
    /**
     * Imposta il valore per il campo Token
     * 
     * @param string $value
     */
    public function setToken($value)
    {
        $this->_token = $value;
    }
    
    /**
     * Ritorna il token associato al pagamento
     * 
     * @return string
     */
    public function getToken()
    {
        return $this->_token;
    }
    
    /**
     * Imposta il valore per il campo CreationDate
     * 
     * @param string $value
     */
    public function setCreationDate($value)
    {
        $this->_creationDate = $value;
    }
    
    /**
     * Ritorna timestamop di creazione del link
     * 
     * @return string
     */
    public function getCreationDate()
    {
        return $this->_creationDate;
    }
    
    /**
     * Imposta il valore per il campo Status
     * 
     * @param string $value
     */
    public function setStatus($value)
    {
        $this->_status = $value;
    }
    
    /**
     * Ritorna lo stato del link
     * 
     * @return string
     */
    public function getStatus()
    {
        return $this->_status;
    }
    
    /**
     * Imposta il valore per il campo LastUseDate
     * 
     * @param string $value
     */
    public function setLastUseDate($value)
    {
        $this->_lastUseDate = $value;
    }
    
    /**
     * Ritorna data di ultimo utilizzo del link
     * 
     * @return string
     */
    public function getLastUseDate()
    {
        return $this->_lastUseDate;
    }
    
    /**
     * Imposta il valore per il campo ExpirationDate
     * 
     * @param string $value
     */
    public function setExpirationDate($value)
    {
        $this->_expirationDate = $value;
    }
    
    /**
     * Ritorna data scadenza del link
     * 
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->_expirationDate;
    }
    
    /**
     * Imposta il valore per il campo RevokeDate
     * 
     * @param string $value
     */
    public function setRevokeDate($value)
    {
        $this->_revokeDate = $value;
    }
    
    /**
     * Ritorna data di revoke del link
     * 
     * @return string
     */
    public function getRevokeDate()
    {
        return $this->_revokeDate;
    }
    
    /**
     * Imposta il valore per il campo OrderId
     * 
     * @param string $value
     */
    public function setOrderId($value)
    {
        $this->_orderId = $value;
    }
    
    /**
     * Ritorna identificativo ordine
     * 
     * @return string
     */
    public function getOrderId()
    {
        return $this->_orderId;
    }
    
    /**
     * Imposta il valore per il campo Mac
     * 
     * @param string $value
     */
    public function setMac($value)
    {
        $this->_mac = $value;
    }
    
    /**
     * Ritorna mac
     * 
     * @return string
     */
    public function getMac()
    {
        return $this->_mac;
    }
    
    /**
     * Imposta il valore per il campo CompleteLink
     * 
     * @param string $value
     */
    public function setCompleteLink($value)
    {
        $this->_completeLink = $value;
    }
    
    /**
     * Ritorna link da utilizzare per il pagamento
     * 
     * @return string
     */
    public function getCompleteLink()
    {
        return $this->_completeLink;
    }
    
    /**
     * Esegue il reset dei campi
     */
    public function reset()
    {
        $this->_result = null;
        $this->_token = null;
        $this->_creationDate = null;
        $this->_status = null;
        $this->_lastUseDate = null;
        $this->_expirationDate = null;
        $this->_revokeDate = null;
        $this->_orderId = null;
        $this->_mac = null;
        $this->_completeLink = null;
    }
    
    /**
     * Ritorna la descrizione dell'errore
     * 
     * @return string
     */
    public function getErrorDesc()
    {
        switch($this->getResult()) {
            case '02': {
                return __('ReqRefNum duplicated or incorrect');
                break;
            }
            case '03': {
                return __('Incorrect message format, missing or incorrect field');
                break;
            }
            case '04': {
                return __('Incorrect API authentication, incorrect MAC');
                break;
            }
            case '06': {
                return __('Unforeseen error during processing of request');
                break;
            }
            case '13': {
                return __('Duplicated order number');
                break;
            }
            case '40': {
                return __('Empty xml or missing ‘date’ parameter');
                break;
            }
            case '41': {
                return __('Xml not parsable');
                break;
            }
            case '98': {
                return __('Application error');
                break;
            }
            case '99': {
                return __('Transaction  failed,  see  specific  outcome  enclosed  in  the element <Data> of the response');
                break;
            }
        }
    }
}