<?php

namespace Cooder\Sia\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 * Source per le lingua della pagina di pagamento
 * per Sia
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Languages implements \Magento\Framework\Option\ArrayInterface
{
    
    const LANGUAGE_ITA = 'ITA';
    const LANGUAGE_ENG = 'EN';
    
    /**
     * Return available language list
     *
     * @return array
     */
    public function getList()
    {
        return [
            self::LANGUAGE_ITA => 'Italian',
            self::LANGUAGE_ENG => 'English',
        ];
    }
    
    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $result = [];
        foreach ($this->toArray() as $key => $label) {
            $result[] = ['value' => $key, 'label' => $label];
        }
        return $result;
    }
    
    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        $result = [];
        foreach ($this->getList() as $code => $label) {
            $result[$code] = __($label);
        }
        return $result;
    }
}
