<?php

namespace Cooder\Sia\Model\Config\Source;

/**
 * Source per la tecnologia di criptazione
 * da utilizzare
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Hash implements \Magento\Framework\Option\ArrayInterface
{
    
    const HASH_SHA1 = 'sha1';
    const HASH_MD5 = 'md5';
    const HASH_HMAC = 'hmac';
    
    /**
     * Return available currency list
     * 
     * @return array
     */
    public function getList()
    {
        return [
            self::HASH_SHA1 => 'SHA1',
            self::HASH_MD5 => 'MD5',
            self::HASH_HMAC => 'HMAC-256'
        ];
    }
    
    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $result = [];
        foreach ($this->toArray() as $key => $label) {
            $result[] = ['value' => $key, 'label' => $label];
        }
        return $result;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        $result = [];
        foreach ($this->getList() as $code => $label) {
            $result[$code] = __($label);
        }
        return $result;
    }
}