<?php

namespace Cooder\Sia\Model\Config\Source;

/**
 * Source per l'ambiente da utilizzare
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Environment implements \Magento\Framework\Option\ArrayInterface
{
    
    const SANDBOX = 1;
    const PRODUCTION = 2;
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::SANDBOX, 'label' => __('Si')], 
            ['value' => self::PRODUCTION, 'label' => __('No')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [self::SANDBOX => __('Si'), self::PRODUCTION => __('No')];
    }
}