<?php

namespace Cooder\Sia\Model\Config\Source;

/**
 * Source per le currency disponibili nel metodo
 * di pagamento Sia
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Currency implements \Magento\Framework\Option\ArrayInterface
{
    
    const CURRENCY_CODE_EUR = '978';
    const CURRENCY_CODE_USD = '840';
    
    /**
     * Return available currency list
     * 
     * @return array
     */
    public function getList()
    {
        return [
            self::CURRENCY_CODE_EUR => 'Euro',
            self::CURRENCY_CODE_USD => 'US Dollar',
        ];
    }
    
    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $result = [];
        foreach ($this->toArray() as $key => $label) {
            $result[] = ['value' => $key, 'label' => $label];
        }
        return $result;
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        $result = [];
        foreach ($this->getList() as $code => $label) {
            $result[$code] = __($label);
        }
        return $result;
    }
}
