<?php

namespace Cooder\Sia\Model\Config\Source\Authorization;

/**
 * Source per il transaction status type delle autorizzazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class TransactionStatus implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '00', 'label' => __('Authorization granted, bookable')], 
            ['value' => '01', 'label' => __('Authorization denied')], 
            ['value' => '02', 'label' => __('Booked authorization to be processed')], 
            ['value' => '03', 'label' => __('Booked authorization processed by clearing')],
            ['value' => '04', 'label' => __('Reversed authorization')], 
            ['value' => '21', 'label' => __('Authorization to be reversed due to transaction error')], 
            ['value' => '99', 'label' => __('Authorization underway with MyBank')],
            ['value' => '10', 'label' => __('Deferred authorization open')], 
            ['value' => '11', 'label' => __('Deferred authorization closed')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '00' => __('Authorization granted, bookable'),
            '01' => __('Authorization denied'),
            '02' => __('Booked authorization to be processed'),
            '03' => __('Booked authorization processed by clearing'),
            '04' => __('Reversed authorization'),
            '21' => __('Authorization to be reversed due to transaction error'),
            '99' => __('Authorization underway with MyBank'),
            '10' => __('Deferred authorization open'),
            '11' => __('Deferred authorization closed')
        ];
    }
}