<?php

namespace Cooder\Sia\Model\Config\Source\Authorization;

/**
 * Source per il transaction result type delle autorizzazioni
 *
 * @author Devid Marcantoni <devid@cooder.it>
 */
class TransactionResult implements \Magento\Framework\Option\ArrayInterface
{
    
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '00', 'label' => __('Success')], 
            ['value' => '01', 'label' => __('Denied due to problems in the request message')], 
            ['value' => '02', 'label' => __('Denied due to problems in the store registry')], 
            ['value' => '03', 'label' => __('Denied due to communication problems with the authorization circuits')],
            ['value' => '04', 'label' => __('Denied by card issuer')], 
            ['value' => '05', 'label' => __('Denied due to incorrect card number')], 
            ['value' => '06', 'label' => __('Unforeseen error during processing of request')],
            ['value' => '45', 'label' => __('Denied authorization due to foreign card filter')], 
            ['value' => '99', 'label' => __('Authorization underway with MyBank or Jiffy')],
            ['value' => '60', 'label' => __('Denied due to failed antifraud check Riskshield')],
            ['value' => '61', 'label' => __('Denied due to failed antifraud check AmexPan')],
            ['value' => '62', 'label' => __('Denied due to failed antifraud check AmexPanIP')],
            ['value' => '63', 'label' => __('Denied due to failed antifraud check H3GPan')],
            ['value' => '64', 'label' => __('Denied due to failed antifraud check ItaPanCountry')],
            ['value' => '65', 'label' => __('Denied due to failed antifraud check PaypalCountry')],
            ['value' => '66', 'label' => __('Denied due to failed antifraud check CardEnrolledAuthenticate')],
            ['value' => '67', 'label' => __('Denied due to failed antifraud check PanBlackList')],
            ['value' => '68', 'label' => __('Denied due to failed antifraud check CountryPan')],
            ['value' => '69', 'label' => __('Denied due to failed antifraud check PrepaidPan')]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '00' => __('Success'),
            '01' => __('Denied due to problems in the request message'),
            '02' => __('Denied due to problems in the store registry'),
            '03' => __('Denied due to communication problems with the authorization circuits'),
            '04' => __('Denied by card issuer'),
            '05' => __('Denied due to incorrect card number'),
            '06' => __('Unforeseen error during processing of request'),
            '45' => __('Denied authorization due to foreign card filter'),
            '99' => __('Authorization underway with MyBank or Jiffy'),
            '60' => __('Denied due to failed antifraud check Riskshield'),
            '61' => __('Denied due to failed antifraud check AmexPan'),
            '62' => __('Denied due to failed antifraud check AmexPanIP'),
            '63' => __('Denied due to failed antifraud check H3GPan'),
            '64' => __('Denied due to failed antifraud check ItaPanCountry'),
            '65' => __('Denied due to failed antifraud check PaypalCountry'),
            '66' => __('Denied due to failed antifraud check CardEnrolledAuthenticate'),
            '67' => __('Denied due to failed antifraud check PanBlackList'),
            '68' => __('Denied due to failed antifraud check CountryPan'),
            '69' => __('Denied due to failed antifraud check PrepaidPan')
        ];
    }
    
    public static function getOptionArray()
    {
        return [
            ['value' => '00', 'label' => __('Success')],
            ['value' => '01', 'label' => __('Denied due to problems in the request message')],
            ['value' => '02', 'label' => __('Denied due to problems in the store registry')],
            ['value' => '03', 'label' => __('Denied due to communication problems with the authorization circuits')],
            ['value' => '04', 'label' => __('Denied by card issuer')],
            ['value' => '05', 'label' => __('Denied due to incorrect card number')],
            ['value' => '06', 'label' => __('Unforeseen error during processing of request')],
            ['value' => '45', 'label' => __('Denied authorization due to foreign card filter')],
            ['value' => '99', 'label' => __('Authorization underway with MyBank or Jiffy')],
            ['value' => '60', 'label' => __('Denied due to failed antifraud check Riskshield')],
            ['value' => '61', 'label' => __('Denied due to failed antifraud check AmexPan')],
            ['value' => '62', 'label' => __('Denied due to failed antifraud check AmexPanIP')],
            ['value' => '63', 'label' => __('Denied due to failed antifraud check H3GPan')],
            ['value' => '64', 'label' => __('Denied due to failed antifraud check ItaPanCountry')],
            ['value' => '65', 'label' => __('Denied due to failed antifraud check PaypalCountry')],
            ['value' => '66', 'label' => __('Denied due to failed antifraud check CardEnrolledAuthenticate')],
            ['value' => '67', 'label' => __('Denied due to failed antifraud check PanBlackList')],
            ['value' => '68', 'label' => __('Denied due to failed antifraud check CountryPan')],
            ['value' => '69', 'label' => __('Denied due to failed antifraud check PrepaidPan')]
        ];
    }
}