<?php

namespace Cooder\Sia\Model\Config\Backend;

/**
 * Source per il logo del metodo di pagamento
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Image extends \Magento\Config\Model\Config\Backend\Image
{
        
    /**
     * The tail part of directory path for uploading
     */
    const UPLOAD_DIR = 'siapay';
    
    /**
     * Upload max file size in kilobytes
     *
     * @var int
     */
    protected $_maxFileSize = 2048;
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Model\Config\Backend\File::_getUploadDir()
     */
    protected function _getUploadDir()
    {
        return $this->_mediaDirectory->getAbsolutePath($this->_appendScopeInfo(self::UPLOAD_DIR));
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Model\Config\Backend\File::_addWhetherScopeInfo()
     */
    protected function _addWhetherScopeInfo()
    {
        return true;
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Model\Config\Backend\Image::_getAllowedExtensions()
     */
    protected function _getAllowedExtensions()
    {
        return ['jpg', 'jpeg', 'png'];
    }
    
    /**
     * Get tmp file name
     * 
     * @return string
     */
    protected function getTmpFileName()
    {
        $tmpName = null;
        if (isset($_FILES['groups'])) {
            $tmpName = $_FILES['groups']['tmp_name'][$this->getGroupId()]['fields'][$this->getField()]['value'];
        } else {
            $tmpName = is_array($this->getValue()) ? $this->getValue()['tmp_name'] : null;
        }
        return $tmpName;
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Model\Config\Backend\File::beforeSave()
     */
    public function beforeSave()
    {
        $value = $this->getValue();
        $deleteFlag = is_array($value) && !empty($value['delete']);
        $fileTmpName = $this->getTmpFileName();
        if ($this->getOldValue() && ($fileTmpName || $deleteFlag)) {
            $this->_mediaDirectory->delete(self::UPLOAD_DIR . '/' . $this->getOldValue());
        }
        return parent::beforeSave();
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Model\Config\Backend\File::_prependScopeInfo()
     */
    protected function _prependScopeInfo($path)
    {
        if (\Magento\Framework\App\Config\ScopeConfigInterface::SCOPE_TYPE_DEFAULT != $this->getScope()) {
            return $this->getScope() . '/' . $this->getScopeId() . '/' . $path;
        } else {
            return 'defaultsia/' . $path;
        }
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Model\Config\Backend\File::_appendScopeInfo()
     */
    protected function _appendScopeInfo($path)
    {
        if (\Magento\Framework\App\Config\ScopeConfigInterface::SCOPE_TYPE_DEFAULT != $this->getScope()) {
            return $path . '/' . $this->getScope() . '/' . $this->getScopeId();
        } else {
            return $path . '/defaultsia';
        }
    }
}