<?php

namespace Cooder\Sia\Controller\Redirect;

/**
 * Controller per il redirect alla pagina di pagamento SiaPay
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Index extends \Magento\Framework\App\Action\Action
{
    /**
     * Checkout Session
     * 
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;
    
    /**
     * Order Factory
     * 
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $_orderFactory;
    
    /**
     * Costruttore
     * 
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Sales\Model\OrderFactory $orderFactory
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context, 
        \Magento\Checkout\Model\Session $checkoutSession, 
        \Magento\Sales\Model\OrderFactory $orderFactory
    )
    {
        parent::__construct($context);
        $this->_checkoutSession = $checkoutSession;
        $this->_orderFactory = $orderFactory;
    }
    
    /**
     * Dispatch request
     * 
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     * @throws \Exception
     */
    public function execute()
    {
        $payment = $this->_getOrder()->getPayment();
        return $this->_redirect($payment->getAdditionalInformation(\Cooder\Sia\Model\SiaPay::PAYMENT_URL_ADDITIONAL_INFO_KEY));
    }
    
    /**
     * Ritorna ordine corrente
     * 
     * @return \Magento\Sales\Model\Order
     */
    protected function _getOrder()
    {
        return $this->_orderFactory->create()->loadByIncrementId($this->_checkoutSession->getLastRealOrderId());
    }
}
