<?php

namespace Cooder\Sia\Controller\Payment;

/**
 * Controller per la pagina di risultato in caso di cancellazione
 * di pagamento SiaPay
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class Cancel extends \Magento\Framework\App\Action\Action
{
    
    /**
     * Checkout Session
     *
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;
    
    /**
     * Logger del modulo
     *
     * @var \Cooder\Sia\Logger\Logger
     */
    protected $_baseLogger;
    
    /**
     * Scope Config
     *
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;
    
    /**
     * Costruttore
     * 
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Cooder\Sia\Logger\Logger $baseLogger
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Cooder\Sia\Logger\Logger $baseLogger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        parent::__construct($context);
        $this->_checkoutSession = $checkoutSession;
        $this->_baseLogger = $baseLogger;
        $this->_scopeConfig = $scopeConfig;
    }
    
    /**
     * Esecuzione delle verifiche sulla risposta di
     * pagamento dal server Sia
     */
    public function execute()
    {
        $this->_baseLogger->debug('Cancel operation: start');
        
        // Recupero ordine in sessione
        $lastOrder = $this->_checkoutSession->getLastRealOrder();
        
        // Istanzio metodo di pagamento
        $payment = $lastOrder->getPayment();
        if (!$payment instanceof \Magento\Payment\Model\InfoInterface) {
            $this->_baseLogger->debug('Payment object is not a PaymentInfo!');
            return $this->_sendErrorResponse();
        }
        
        $paymentMethodInstance = $payment->getMethodInstance();
        if (!$paymentMethodInstance instanceof \Cooder\Sia\Model\SiaPay) {
            $this->_baseLogger->debug(
                'Notification is not about an SiaPay payment! Payment method object: '.
                get_class($paymentMethodInstance)
            );
            return $this->_sendErrorResponse();
        }
            
        // Eseguo verifica dei dati di pagamento
        $paymentMethodInstance->cancelOperation($lastOrder);
        $url = $this->_scopeConfig->getValue('payment/sia/url_cancel', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        if(empty($url)) {
            return $this->_redirect('checkout/cart');
        } else {
            return $this->_redirect($url);
        }
        
    }
    
    /**
     * Invia response di errore
     *
     * @return \Magento\Framework\App\ResponseInterface
     */
    protected function _sendErrorResponse()
    {
        $response = $this->getResponse();
        $response->setHttpResponseCode(500);
        return $response;
    }
    
}