<?php

namespace Cooder\Sia\Block\System\Config;

/**
 * Blocco per la rappresentazione della lista dei bottoni 
 * nella configurazione del modulo
 * 
 * @author Devid Marcantoni <devid@cooder.it>
 */
class ActionButtonList extends \Magento\Config\Block\System\Config\Form\Field
{
    
    /**
     * Template
     * 
     * @var string
     */
    protected $_template = 'Cooder_Sia::system/config/action_button_list.phtml';

    /**
     * Costruttore
     * 
     * @param \Magento\Backend\Block\Template\Context $context
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        array $data = []
    ) 
    {
        parent::__construct($context, $data);
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Block\System\Config\Form\Field::render()
     */
    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }
    
    /**
     * {@inheritDoc}
     * @see \Magento\Config\Block\System\Config\Form\Field::_getElementHtml()
     */
    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        return $this->_toHtml();
    }
}