<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at thisURL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_SizeChart
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\SizeChart\Controller\Adminhtml\SizeChart;

use Magento\Backend\App\Action;
use Magento\Framework\App\ResourceConnection;
use Bss\SizeChart\Model\SizeChartRepository;
use Bss\SizeChart\Model\ResourceModel\SizeChart;

/**
 * Class Save
 *
 * @package Bss\SizeChart\Controller\Adminhtml\SizeChart
 */
class Save extends Action
{

    /**
     * const
     */
    const ADMIN_RESOURCE = 'Bss_SizeChart::save';

    /**
     * ResourceConnection
     *
     * @var ResourceConnection
     */
    protected $resource;

    /**
     * SizeChart
     *
     * @var SizeChart
     */
    protected $resourceSizeChart;

    /**
     * Resource Rule
     * @var \Bss\SizeChart\Model\ResourceModel\Rule
     */
    protected $resourceRule;

    /**
     * Rule Factory
     *
     * @var \Bss\SizeChart\Model\RuleFactory
     */
    protected $ruleFactory;

    /**
     * Helper Data
     *
     * @var \Bss\SizeChart\Helper\Data
     */
    protected $helper;

    /**
     * SizeChartRepository
     *
     * @var SizeChartRepository $sizeChartRepository
     */
    protected $sizeChartRepository;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $collectionFactory;

    /**
     * @var \Magento\Catalog\Model\Product\Action
     */
    protected $action;

    /**
     * Save constructor.
     * @param Action\Context $context
     * @param ResourceConnection $resource
     * @param SizeChart $resourceSizeChart
     * @param \Bss\SizeChart\Model\ResourceModel\Rule $resourceRule
     * @param \Bss\SizeChart\Model\RuleFactory $ruleFactory
     * @param \Bss\SizeChart\Helper\Data $helper
     * @param SizeChartRepository $sizeChartRepository
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     * @param \Magento\Catalog\Model\Product\Action $action
     */
    public function __construct(
        Action\Context $context,
        ResourceConnection $resource,
        SizeChart $resourceSizeChart,
        \Bss\SizeChart\Model\ResourceModel\Rule $resourceRule,
        \Bss\SizeChart\Model\RuleFactory $ruleFactory,
        \Bss\SizeChart\Helper\Data $helper,
        SizeChartRepository $sizeChartRepository,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory,
        \Magento\Catalog\Model\Product\Action $action
    ) {
        parent::__construct($context);
        $this->resource = $resource;
        $this->resourceSizeChart = $resourceSizeChart;
        $this->resourceRule = $resourceRule;
        $this->ruleFactory = $ruleFactory;
        $this->helper = $helper;
        $this->sizeChartRepository = $sizeChartRepository;
        $this->collectionFactory = $collectionFactory;
        $this->action = $action;
    }

    /**
     * Get default display
     *
     * @return int
     */
    protected function getDefaultDisplay()
    {
        $displayDefault = $this->helper->getDefaultDisplay();
        $displayDefaultReturn = isset($displayDefault) ? $displayDefault : 1;
        return $displayDefaultReturn;
    }

    /**
     * Treat String
     *
     * @param array $stringDataDisplay
     * @return string
     */
    protected function treatString($stringDataDisplay = [])
    {
        $stringDisplay = implode(",", $stringDataDisplay);
        return $stringDisplay;
    }

    /**
     * Handle Data Rule
     *
     * @param array $data
     * @return array
     */
    protected function handleDataRule($data)
    {
        if (isset($data['rule'])) {
            $data['conditions'] = $data['rule']['conditions'];
            unset($data['rule']);
        }
        return $data;
    }

    /**
     * Handle when enable single store mode.
     *
     * @param array $data
     * @return void
     */
    protected function handleSingleStoreMode(&$data)
    {
        if ($data['id_store'] == null || !isset($data['id_store'])) {
            $data['id_store'] = 0;
        }
    }

    /**
     * Save
     *
     * @return \Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $stringDisplay = isset(
            $data["display_popup"]
        ) ? $this->treatString($data["display_popup"]) : $this->getDefaultDisplay();
        $data["display_popup"] = $stringDisplay;
        $overwrite = isset($data["overwrite"]) ? "1" : "0";
        $this->handleSingleStoreMode($data);
        if ($data) {
            try {
                $modelRule = $this->ruleFactory->create();
                $id = $this->getRequest()->getParam('size_chart_value_id');
                $data = $this->handleDataRule($data);
                if ($id) {
                    $model = $this->sizeChartRepository->getById($id);
                    $idRule = $this->resourceRule->getRuleBySizeChartId($id);
                    if ($idRule) {
                        $modelRule->load($idRule);
                    }
                } else {
                    $model = $this->sizeChartRepository->getById();
                }
                $model->setData($data);
                $this->sizeChartRepository->save($model);
                $data['size_chart_id'] = $model->getId();
                $modelRule->loadPost($data);
                $modelRule->save();

                $sizeChartId = $model->getId();
                if (isset($data['auto_apply'])) {
                    $data['products'] = $modelRule->getProductIds();
                    $dataProductSizeChart = [];
                    foreach ($data['products'] as $productId) {
                        $dataProductSizeChart[] = [
                            'size_chart_id' => $sizeChartId,
                            'product_id' => $productId,
                            'overwrite' => $overwrite
                        ];
                    }
                    $whereProductSizeChart = [
                        'size_chart_id = ?' => $sizeChartId
                    ];
                    $this->resourceSizeChart->deleteMultiData('bss_product_sizechart', $whereProductSizeChart);
                    $this->resourceSizeChart->insertMultiData('bss_product_sizechart', $dataProductSizeChart);
                }
                $this->messageManager->addSuccessMessage(__('The size chart has been saved.'));
                $this->helper->setSessionForm();
                return $this->redirectBackEditPage($model->getId(), $resultRedirect);
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e, __($e->getMessage()));
            }

            $this->_getSession()->setFormData($data);
            return $resultRedirect->setPath('*/*/edit', [
                'size_chart_value_id' => $this->getRequest()->getParam('size_chart_value_id')
            ]);
        }
        return $resultRedirect->setPath('*/*/');
    }

    /**
     * Redirect Back Edit Page
     *
     * @param int $id
     * @param mixed $resultRedirect
     * @return mixed
     */
    protected function redirectBackEditPage($id, $resultRedirect)
    {
        if ($this->getRequest()->getParam('back')) {
            return $resultRedirect->setPath('*/*/edit', [
                'size_chart_value_id' => $id,
                '_current' => true
            ]);
        }
        return $resultRedirect->setPath('*/*/');
    }
}
