<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at thisURL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_SizeChart
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\SizeChart\Controller\Adminhtml\SizeChart;

use Magento\Backend\App\Action;

class ApplyProduct extends \Magento\Backend\App\Action
{
    /**
     *
     * @var \Bss\SizeChart\Model\ApplyProduct
     */
    protected $applyProduct;

    /**
     * ApplyProduct constructor.
     * @param Action\Context $context
     * @param \Bss\SizeChart\Model\ApplyProduct $applyProduct
     */
    public function __construct(
        Action\Context $context,
        \Bss\SizeChart\Model\ApplyProduct $applyProduct
    ) {
        parent::__construct($context);
        $this->applyProduct = $applyProduct;
    }

    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $this->applyProduct->execute();
        $this->messageManager->addSuccessMessage(
            __('Updated rules applied.')
        );
        // go to grid
        return $resultRedirect->setPath('*/*/');
    }
}
