<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at thisURL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_SizeChart
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\SizeChart\Model;

class ApplyProduct
{
    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resource;

    /**
     * @var \Bss\SizeChart\Model\ResourceModel\SizeChart
     */
    protected $resourceSizeChart;

    /**
     * @var \Bss\SizeChart\Model\ResourceModel\Rule
     */
    protected $resourceRule;

    /**
     * @var \Bss\SizeChart\Model\RuleFactory
     */
    protected $ruleFactory;

    /**
     * @var \Bss\SizeChart\Helper\Data
     */
    protected $helper;

    /**
     * ApplyProduct constructor.
     * @param \Magento\Framework\App\ResourceConnection $resource
     * @param \Bss\SizeChart\Model\ResourceModel\SizeChart $resourceSizeChart
     * @param \Bss\SizeChart\Model\ResourceModel\Rule $resourceRule
     * @param \Bss\SizeChart\Model\RuleFactory $ruleFactory
     * @param \Bss\SizeChart\Helper\Data $helper
     */
    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource,
        \Bss\SizeChart\Model\ResourceModel\SizeChart $resourceSizeChart,
        \Bss\SizeChart\Model\ResourceModel\Rule $resourceRule,
        \Bss\SizeChart\Model\RuleFactory $ruleFactory,
        \Bss\SizeChart\Helper\Data $helper
    ) {
        $this->resource = $resource;
        $this->resourceSizeChart = $resourceSizeChart;
        $this->resourceRule = $resourceRule;
        $this->ruleFactory = $ruleFactory;
        $this->helper = $helper;
    }

    /**
     * Execute full indexation
     *
     * @return void
     */
    public function execute()
    {
        $collection_rule =  $this->ruleFactory->create()->getCollection();
        $rows = [];
        foreach ($collection_rule as $rule) {
            $rule->getMatchingProductIds();
            $productIds = $rule->getProductIds();
            $sizeChartId = $rule->getSizeChartId();
            $overwrite = $rule->getOverwrite();
            $whereProductSizeChart = [
                'size_chart_id = ?' => $sizeChartId
            ];
            $this->resourceSizeChart->deleteMultiData('bss_product_sizechart', $whereProductSizeChart);
            if (!empty($productIds)) {
                foreach ($productIds as $productId) {
                    $rows[] = [
                        'size_chart_id' => $sizeChartId,
                        'product_id' => $productId,
                        'overwrite' => $overwrite
                    ];

                    if ($this->returnCountRows($rows) == 5000) {
                        $this->resourceSizeChart->insertMultiData('bss_product_sizechart', $rows);
                    }
                }
            }
        }
        if (!empty($rows)) {
            $this->resourceSizeChart->insertMultiData('bss_product_sizechart', $rows);
        }
    }

    /**
     * @param array $rows
     * @return int|void
     */
    protected function returnCountRows($rows)
    {
        return count($rows);
    }
}
