<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at thisURL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_SizeChart
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\SizeChart\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class RemoveBlock implements ObserverInterface
{
    /**
     * Remove Block action
     *
     * @param Observer $observer
     * 
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute(Observer $observer)
    {
        /** @var \Magento\Framework\View\Layout $layout */
        $layout = $observer->getLayout();

        $block = $layout->getBlock('bss_sizechart_tab');

        if (isset($block) && $block) {
            $idProduct = $block->getProduct()->getId();
            $sizeChart = $block->getAllSizeChartByStoreView($idProduct, $block->getStoreId());
            $popUp = $sizeChart->getPopUp();
            if (!$block->checkDisplay($popUp, '1')) {
                $layout->unsetElement('bss_sizechart_tab');
            }
        }

    }
}
