<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at thisURL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_SizeChart
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\SizeChart\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{

    /**
     * UrlInterface
     *
     * @var \Magento\Backend\Model\UrlInterface
     */
    protected $_backendUrl;

    /**
     * StoreManagerInterface
     *
     * @var \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    protected $storeManager;

    /**
     * ScopeConfigInterface
     *
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Backend\Model\UrlInterface $backendUrl
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Backend\Model\UrlInterface $backendUrl,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->_backendUrl = $backendUrl;
        $this->storeManager = $storeManager;
        $this->scopeConfig = $context->getScopeConfig();
        parent::__construct($context);
    }

    /**
     * Get products tab Url in admin
     * @return string
     */
    public function getProductsGridUrl()
    {
        return $this->_backendUrl->getUrl(
            'bss_size_chart_admin/sizechart/products',
            ['_current' => true]
        );
    }

    /**
     * Get Config Title
     *
     * @return string
     */
    public function getConfigTitle()
    {
        return  $this->scopeConfig->getValue(
            'bss_sizechart/bss_sizechart_setting/text_button_bss_sizechart',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get Config Icon
     *
     * @return string
     */
    public function getConfigIcon()
    {
        return $this->scopeConfig->getValue(
            'bss_sizechart/bss_sizechart_setting/button_icon_bss_sizechart',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get Config Color
     *
     * @return string
     */
    public function getConfigColor()
    {
        return  $this->scopeConfig->getValue(
            'bss_sizechart/bss_sizechart_setting/button_text_color',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

}
