/**
* BSS Commerce Co.
*
* NOTICE OF LICENSE
*
* This source file is subject to the EULA
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://bsscommerce.com/Bss-Commerce-License.txt
*
* =================================================================
*                 MAGENTO EDITION USAGE NOTICE
* =================================================================
* This package designed for Magento COMMUNITY edition
* BSS Commerce does not guarantee correct work of this extension
* on any other Magento edition except Magento COMMUNITY edition.
* BSS Commerce does not provide extension support in case of
* incorrect edition usage.
* =================================================================
*
* @category   BSS
* @package    Bss_PreviousNextProduct
* @author     Extension Team
* @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
* @license    http://bsscommerce.com/Bss-Commerce-License.txt
*/
define([
    'jquery'
    ], function ($) {
        'use strict';
        $.widget('bss.bss_config', {
            _create: function () {
                var options = this.options;
                var ajaxUrl = options.ajaxUrl;
                var nameBack = options.nameBack;
                var currentUrl = options.currentUrl;
                var labelBack = options.labelBack;
                var nextPage = '';
                var prevPage = '';

                function createCookie(name, value, days) {
                    var expires;
                    if (days) {
                        var date = new Date();
                        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                        expires = "; expires=" + date.toGMTString();
                    }
                    else {
                        expires = "";
                    }
                    document.cookie = name + "=" + value + expires + "; path=/";
                }

                function getCookie(c_name) {
                    if (document.cookie.length > 0) {
                        var c_start;
                        var c_end;
                        c_start = document.cookie.indexOf(c_name + "=");
                        if (c_start != -1) {
                            c_start = c_start + c_name.length + 1;
                            c_end = document.cookie.indexOf(";", c_start);
                            if (c_end == -1) {
                                c_end = document.cookie.length;
                            }
                            return unescape(document.cookie.substring(c_start, c_end));
                        }
                    }
                    return "";
                }

                $(document).ready(function() {
                    var ajaxDataNext = '';
                    var ajaxDataPrev = '';
                    var ajaxDataCurrent = '';

                    $('.price-box.price-final_price').each(function(){
                        var id_product = $(this).attr("data-product-id");
                        ajaxDataCurrent = ajaxDataCurrent+id_product+',';
                    });

                    var cookieData = ajaxDataCurrent;
                    cookieData = cookieData.substr(0, cookieData.length - 1);

                    currentUrl = currentUrl.replace(/&amp;/g, "&");

                    createCookie("label-back",labelBack,"1");
                    createCookie("cookie-data",cookieData,"1");
                    createCookie("name-back",nameBack,"1");
                    createCookie("current-url",currentUrl,"1");


                    prevPage = $('.action.previous').attr("href");
                    nextPage = $('.action.next').attr("href");

                    if (nextPage !== '' && nextPage !== null && typeof nextPage !== "undefined") {
                        $.ajax({
                            url: nextPage,
                            type:'GET',
                            success: function(data){
                                var website = $(data).find('.products.wrapper.grid.products-grid').html();
                                $(website).find('.price-box.price-final_price').each(function(){
                                    var id_next = $(this).attr("data-product-id");
                                    ajaxDataNext = ajaxDataNext+id_next+',';
                                });
                                
                                ajaxDataNext = ajaxDataNext.substr(0, ajaxDataNext.length - 1);
                                var updateDataNext = getCookie('cookie-data');
                                updateDataNext = updateDataNext+','+ajaxDataNext;
                                createCookie("cookie-data",updateDataNext,"1");

                            }
                        });
                    }

                    if (prevPage !== '' && prevPage !== null && typeof prevPage !== "undefined") {
                        $.ajax({
                            url: prevPage,
                            type:'GET',
                            success: function(data){
                                var website = $(data).find('.products.wrapper.grid.products-grid').html();
                                $(website).find('.price-box.price-final_price').each(function(){
                                    var id_next = $(this).attr("data-product-id");
                                    ajaxDataPrev = ajaxDataPrev+id_next+',';
                                });

                                ajaxDataPrev = ajaxDataPrev.substr(0, ajaxDataPrev.length - 1);

                                var updateDataPrev = getCookie('cookie-data');
                                updateDataPrev = updateDataPrev+','+ajaxDataPrev;
                                createCookie("cookie-data",updateDataPrev,"1");
                            }
                        });
                    }

                });
            }
        });
        return $.bss.bss_config;
    });
