/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * BSS Commerce does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * BSS Commerce does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   BSS
 * @package    Bss_PreviousNextProduct
 * @author     Extension Team
 * @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
define([
    'jquery'
    ], function ($) {
        
    'use strict';
    $.widget('bss.bss_config', {
        _create: function () {
            function getCookie(c_name) {
                if (document.cookie.length > 0) {
                    var c_start;
                    var c_end;
                    c_start = document.cookie.indexOf(c_name + "=");
                    if (c_start != -1) {
                        c_start = c_start + c_name.length + 1;
                        c_end = document.cookie.indexOf(";", c_start);
                        if (c_end == -1) {
                            c_end = document.cookie.length;
                        }
                        return unescape(document.cookie.substring(c_start, c_end));
                    }
                }
                return "";
            }
            var labelBack = getCookie('label-back');
            var cookieData = getCookie('cookie-data');
            var nameBack = getCookie('name-back');
            var currentUrl = getCookie('current-url');
            var options = this.options;
            var ajaxUrl = options.ajaxUrl;
            var ajaxData = options.ajaxData;
            var baseUrl = options.baseUrl;
            $(document).ready(function() {
                $.ajax({
                    showLoader: false,
                    url: ajaxUrl,
                    data : {
                        data : ajaxData,
                        cookieData : cookieData,
                        currentUrl: currentUrl,
                        nameBack: nameBack,
                        labelBack: labelBack,
                        type: 'current'
                    },
                    type: "POST",
                    dataType: 'json',
                    complete: function(response) {            
                        var result = response.responseText;
                        result = JSON.parse(result);
                        if (result == 'Nothing') {
                        } else {
                            var currentUrl = b64DecodeUnicode(result['currentUrl']);
                            currentUrl = currentUrl.replace(/&amp;/g, "&");
                            $(".bss-previous-next-block").css("display", "inline");
                            if(result['name_prev'] === "hide" || result['img_prev'] === "hide" || result['url_prev'] === "hide"){
                                $(".bss-previous-next-block #previous").hide();
                            } else{
                                result['img_prev'] = result['img_prev'];
                                $('h5.prev_name').html(atob(result['name_prev']));
                                $("img#prev_img").attr("src",result['img_prev']);
                                $("a#prev_url").attr("href",result['url_prev']);
                            }
                            if(result['name_next'] === "hide" || result['img_next'] === "hide" || result['url_next'] === "hide"){
                                $(".bss-previous-next-block #next").hide();
                            } else{
                                result['img_next'] = result['img_next'];
                                $('h5.next_name').html(atob(result['name_next']));
                                $("img#next_img").attr("src",result['img_next']);
                                $("a#next_url").attr("href",result['url_next']);
                            }                            
                            $("a#backUrl").attr("href",currentUrl);
                            $("a#backUrl").attr("title",b64DecodeUnicode(result['nameBack']));
                            $("a#backUrl").html(b64DecodeUnicode(result['labelBack']));
                        }
                    },
                    error: function (xhr, status, errorThrown) {
                        console.log('Error happens. Try again.');
                    }
                });
            });
        }
    });
    function b64DecodeUnicode(str) {
        // Going backwards: from bytestream, to percent-encoding, to original string.
        return decodeURIComponent(atob(str).split('').map(function(c) {
            return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
        }).join(''));
    }
    return $.bss.bss_config;
});