<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category  BSS
 * @package   Bss_PreviousNextProduct
 * @author    Extension Team
 * @copyright Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license   http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\PreviousNextProduct\Model\Config\Backend;

class CheckNumber extends \Magento\Framework\App\Config\Value
{
    /**
     * @return $this
     * @throws \Magento\Framework\Exception\ValidatorException
     */
    public function beforeSave()
    {
        $label = $this->getData('field_config/label');

        if ($this->getValue() == '') {
            $this->setValue(intval($this->getValue()));

            return parent::beforeSave();
        } elseif (!is_numeric($this->getValue())) {
            throw new \Magento\Framework\Exception\ValidatorException($label .__(' is not a number.'));
        } elseif ($this->getValue() < 0) {
            throw new \Magento\Framework\Exception\ValidatorException($label .__(' is less than 0.'));
        }

        $this->setValue(intval($this->getValue()));

        return parent::beforeSave();
    }
}
