<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * BSS Commerce does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * BSS Commerce does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   BSS
 * @package    BSS_HtmlSiteMap
 * @author     Extension Team
 * @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\PreviousNextProduct\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlInterface;

    /**
     * @var int
     */
    protected $storeId;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Data constructor.
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\App\Helper\Context $context
     */
    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\App\Helper\Context $context
    ) {
        parent::__construct($context);
        $this->urlInterface = $context->getUrlBuilder();
        $this->scopeConfig = $context->getScopeConfig();
        $this->storeManager = $storeManager;
    }

    /**
     * @return int
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getStoreId()
    {
        if ($this->storeId === null) {
            $this->storeId = $this->storeManager->getStore()->getId();
        }
        return $this->storeId;
    }

    /**
     * @return string
     */
    public function getAjaxUrl()
    {
        $baseUrl = $this->urlInterface->getUrl('previousnextproduct');
        return $baseUrl;
    }

    /**
     * @return bool
     */
    public function getConfigStatusModule()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/status_module',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return ($data == '1') ? true : false;
    }

    /**
     * Get setting module sort orderby
     * @return string
     */
    public function getConfigSortOrder()
    {
        $values = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/sort_by',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $values;
    }

    /**
     * Get setting module fontend background color
     * @return string
     */
    public function getConfigBackgroundColor()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/button_bg_color',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * Get setting module fontend text color
     * @return string
     */
    public function getConfigTextColor()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/button_text_color',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * Get setting module fontend position button
     * @return int
     */
    public function getConfigPositionButton()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/position_button',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * Get setting module fontend label button next
     * @return string
     */
    public function getConfigLabelNextButton()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/text_next',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        if ($data == "") {
            $data = __("NEXT");
        }
        return $data;
    }

    /**
     * Get setting module fontend label button previous
     * @return string
     */
    public function getConfigLabelPreviousButton()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/text_prev',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        if ($data == "") {
            $data = __("PREVIOUS");
        }
        return $data;
    }

    /**
     * Get setting module mini popup
     * @return int
     */
    public function getConfigStatusPopup()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/status_popup',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * Get setting module text length
     * @return int
     */
    public function getConfigTextLength()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/text_length_product_name',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * Get setting module only text on popup
     * @return int
     */
    public function getConfigOnlyTextPopup()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/only_text_popup',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * Get setting module only text on popup
     * @return int
     */
    public function getConfigUseLayer()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/use_layer',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $data;
    }

    /**
     * @return string
     */
    public function getConfigWidth()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/width_thumbnail_image',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        if (!settype($data, 'int') || $data == "") {
            return '200px';
        }
        return $data.'px';
    }

    /**
     * @return string
     */
    public function getConfigHeight()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/height_thumbnail_image',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        if (!settype($data, 'int') || $data == "") {
            return 'auto';
        }
        return $data.'px';
    }

    /**
     * @return string
     */
    public function setWidthPopup()
    {
        $data = $this->scopeConfig->getValue(
            'bss_previous_next_product/general/width_thumbnail_image',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        if (!settype($data, 'int') || $data == "") {
            return '220px';
        }
        $data +=  20;
        return $data.'px';
    }

    /**
     * @return string
     */
    public function setFontSize()
    {
        $size = $this->setWidthPopup();
        $size  /=  10;
        return $size.'px';
    }

    /**
     * Get setting module fontend label button back
     * @return string
     */
    public function getConfigLabelBackButton($isCategory)
    {
        if ($isCategory) {
            $data = $this->scopeConfig->getValue(
                'bss_previous_next_product/general/text_back',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
        } else {
            $data = $this->scopeConfig->getValue(
                'bss_previous_next_product/general/text_back_search',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
        }
        if ($data == "") {
            $data = __("BACK");
        }
        return $data;
    }
}
