<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * BSS Commerce does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * BSS Commerce does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   BSS
 * @package    Bss_PreviousNextProduct
 * @author     Extension Team
 * @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\PreviousNextProduct\Controller\Index;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Bss\Quickview\Helper\Data;

class CheckUrl extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Catalog\Model\ProductRepository
     */
    protected $productRepository;

    /**
     * CheckUrl constructor.
     * @param Context $context
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
     * @param \Bss\PreviousNextProduct\Helper\Data $helper
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Catalog\Model\ProductRepository $productRepository
     */
    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Bss\PreviousNextProduct\Helper\Data $helper,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Catalog\Model\ProductRepository $productRepository
    ) {
        $this->storeManager = $storeManager;
        $this->helper = $helper;
        $this->productRepository = $productRepository;
        $this->resultJsonFactory = $resultJsonFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        if ($this->getRequest()->isAjax()) {
            $id = $this->getRequest()->getPost('data');
            $idString['data'] = $this->getRequest()->getPost('cookieData');
            $idString['currentUrl'] = $this->getRequest()->getPost('currentUrl');
            $idString['nameBack'] = $this->getRequest()->getPost('nameBack');
            $idString['labelBack'] = $this->getRequest()->getPost('labelBack');


            if ($idString['data'] == null || $idString['data'] == '') {
                $test = 'Nothing';
            } else {
                $productString = explode(',', $idString['data']);
                $maxs = 0;
                foreach ($productString as $key2 => $productId2) {
                    $maxs = $key2;
                }
                $error = null;
                if (sizeof($productString) == 1) {
                    $value['next'] = false;
                    $value['prev'] = false;
                } else {
                    foreach ($productString as $key => $productId) {
                        if ($key > 0 && $productId == $id && $key < $maxs) {
                            $value['prev'] = $productString[$key-1];
                            $value['next'] = $productString[$key+1];
                        }
                        if ($key == 0 && $productId == $id) {
                            $value['next'] = $productString[1];
                            $value['prev'] = false;
                        }
                        if ($key == $maxs && $productId == $id) {
                            $value['prev'] = $productString[$key-1];
                            $value['next'] = false;
                        }
                    }
                }
                if (array_search($id, $productString) === false) {
                    $test = 'Nothing';
                } else {
                    $url["prev"] = $value['prev'] ? $this->getUrlProduct($value["prev"]) : "hide";
                    $url["next"] = $value['next'] ? $this->getUrlProduct($value["next"]) : "hide";
                    $img["prev"] = $value['prev'] ? $this->getImageProduct($value["prev"]) : "hide";
                    $img["next"] = $value['next'] ? $this->getImageProduct($value["next"]) : "hide";
                    $name["prev"] = $value['prev'] ? $this->cuttingTextLength($this->getNameProduct($value["prev"])) : "hide";
                    $name["next"] = $value['next'] ? $this->cuttingTextLength($this->getNameProduct($value["next"])) : "hide";
                    $test = [
                        //'labelBack' => __('Back to category'),
                        'labelBack' => $idString['labelBack'],
                        'nameBack' => $idString['nameBack'],
                        'currentUrl' => $idString['currentUrl'],
                        'url_prev' => $url["prev"],
                        'url_next' => $url["next"],
                        'img_prev' => $img["prev"],
                        'img_next' => $img["next"],
                        'name_prev' => base64_encode($name["prev"]),
                        'name_next' => base64_encode($name["next"])
                    ];
                }
            }
            
            $result->setData($test);
            return $result;
        }
    }

    /**
     * @param $str
     * @return bool|string
     */
    protected function cuttingTextLength($str)
    {
        $length = $this->helper->getConfigTextLength();
        if (!settype($length, 'int') || $length == null) {
            return $str;
        }
        $str = substr($str, 0, $length);
        $str = $str."...";
        return $str;
    }

    /**
     * get url product
     * @return string
     */
    protected function getUrlProduct($idProduct)
    {
        $product = $this->productRepository->getById($idProduct);
        return $product->getUrlModel()->getUrl($product);
    }

    /**
     * get url image
     * @return string
     */
    protected function getImageProduct($idProduct)
    {
        $product = $this->productRepository->getById($idProduct);
        $mediaUrl = $this ->storeManager-> getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
        $urlProduct = $mediaUrl.'catalog/product'.$product->getImage($product);
        return $urlProduct;
    }

    /**
     * get name product
     * @return string
     */
    protected function getNameProduct($idProduct)
    {
        $product = $this->productRepository->getById($idProduct);
        return $product->getName($product);
    }
}
