<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * BSS Commerce does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * BSS Commerce does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   BSS
 * @package    Bss_PreviousNextProduct
 * @author     Extension Team
 * @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\PreviousNextProduct\Block;

use Magento\Framework\View\Element\Template;
use Magento\Catalog\Block\Product\ProductList\Toolbar as ToolbarBlock;

class PreviousNextLayer extends \Magento\Framework\View\Element\Template
{
    const SORT_BY = 'bss_previous_next_product/general/sort_by';
    const STATUS = 'bss_previous_next_product/general/status_module';

    /**
     * @var \Magento\Framework\Registry
     */
    public $registry = null;

    /**
     * @var array
     */
    public $category = null;

    /**
     * @var array
     */
    public $logger = null;

    /**
     * @var Template\Context
     */
    public $context = null;

    /**
     * @var \Magento\Catalog\Block\Product\ProductList\Toolbar
     */
    public $toolbar = null;

    /**
     * @var \Magento\Theme\Block\Html\Pager
     */
    public $pager = null;


    /**
     * PreviousNextLayer constructor.
     * @param Template\Context $context
     * @param array $data
     * @param \Bss\PreviousNextProduct\Helper\Data $dataHelper
     * @param \Magento\Framework\Registry $registry
     * @param ToolbarBlock $toolbar
     * @param \Magento\Framework\App\Request\Http $request
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
     * @param ToolbarBlock $toolbarBlock
     * @param \Magento\Theme\Block\Html\Pager $pager
     * @param \Magento\Framework\View\Page\Title $pageTitle
     * @param \Magento\CatalogSearch\Block\Result $resultSearch
     * @param \Magento\Theme\Block\Html\Pager $pageBlock
     * @param \Bss\PreviousNextProduct\Plugin\Toolbar $toolbarPlugin
     */
    public function __construct(
        Template\Context $context,
        array $data = [],
        \Bss\PreviousNextProduct\Helper\Data $dataHelper,
        \Magento\Framework\Registry $registry,
        \Magento\Catalog\Block\Product\ProductList\Toolbar $toolbar,
        \Magento\Framework\App\Request\Http $request,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        ToolbarBlock $toolbarBlock,
        \Magento\Theme\Block\Html\Pager $pager,
        \Magento\Framework\View\Page\Title $pageTitle,
        \Magento\CatalogSearch\Block\Result $resultSearch,
        \Magento\Theme\Block\Html\Pager $pageBlock,
        \Bss\PreviousNextProduct\Plugin\Toolbar $toolbarPlugin
    ) {
        $this->pageBlock = $pageBlock;
        $this->resultSearch = $resultSearch;
        $this->pageTitle = $pageTitle;
        $this->toolbarPlugin = $toolbarPlugin;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->toolbarBlock = $toolbarBlock;
        $this->scopeConfig = $context->getScopeConfig();
        $this->request = $request;
        $this->storeManagerInterface = $context->getStoreManager();
        $this->dataHelper = $dataHelper;
        $this->context = $context;
        $this->storeManager = $context->getStoreManager();
        $this->registry = $registry;
        $this->toolbar = $toolbar;
        $this->pager = $pager;
        $this->urlInterface = $context->getUrlBuilder();
        parent::__construct($context, $data);
    }

    /**
     * @return \Bss\PreviousNextProduct\Helper\Data
     */
    public function getDataHelper()
    {
        return $this->dataHelper;
    }

    /**
     * @return null|string
     */
    public function getAjaxData()
    {
        return $this->toolbarPlugin->getAjaxData();
    }

    /**
     * @return int
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getStoreId()
    {
        return $this->storeManager->getStore()->getId();
    }

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->pageTitle->getShort();
    }

    /**
     * Get setting module sort orderby
     * @return string
     */
    public function getConfigStatusModule()
    {
        $values = $this->scopeConfig->getValue(
            self::STATUS,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $values;
    }

    /**
     * @return mixed
     */
    public function getCurrentCategory()
    {
        $currentCategory = $this->registry->registry('current_category');
        return $currentCategory;
    }

    /**
     * @return mixed
     */
    public function getAllProducts()
    {
        $category = $this->getCurrentCategory();
        $collection = $category->getProductCollection()->addAttributeToSelect('*');
        $collection = $collection->setOrder($this->setSortOrder(), $this->getCurrentDirection());
        return $collection;
    }

    /**
     * Get setting module fontend label button back
     * @return string
     */
    public function getConfigLabelBackButton()
    {
        if ($this->isCategory('catalog_category_view')) {
            $data = $this->scopeConfig->getValue(
                'bss_previous_next_product/general/text_back',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
        } else {
            $data = $this->scopeConfig->getValue(
                'bss_previous_next_product/general/text_back_search',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
        }
        if ($data == "") {
            $data = __("BACK");
        }
        return $data;
    }

    /**
     * @return mixed
     */
    public function getCurrentSearchString()
    {
        return $this->request->getParam('q');
    }

    /**
     * @param $type
     * @return bool
     */
    public function isCategory($type)
    {
        if ($this->request->getFullActionName() == $type) {
            return true;
        }
        return false;
    }

    /**
     * @return string
     */
    public function getNameHoverBack()
    {
        if ($this->isCategory('catalog_category_view')) {
            $category = $this->registry->registry('current_category');
            return __('Back to Category: ').$category->getName();
        } else {
            return __('Back to ').$this->getTitle();
        }
    }

    /**
     * @return string
     */
    public function getCurrentUrl()
    {
        return $this->urlInterface->getCurrentUrl();
    }

    /**
     * set value sort order
     * @return string
     */
    public function setSortOrder()
    {
        switch ($this->getConfigSortOrder()) {
            case 'name':
                return 'name';
                break;
            case 'position':
                return 'position';
                break;
            case 'price':
                return 'price';
                break;
            case 'random':
                return $this->getCurrentOrder();
                break;
        }
    }

    /**
     * Get current Order
     * @return string
     */
    public function getCurrentOrder()
    {
        return $this->toolbarBlock->getCurrentOrder();
    }

    /**
     * Get current Direction
     * @return string
     */
    public function getCurrentDirection()
    {
        return $this->toolbarBlock->getCurrentDirection();
    }

    /**
     * Get setting module sort orderby
     * @return string
     */
    public function getConfigSortOrder()
    {
        $values = $this->scopeConfig->getValue(
            self::SORT_BY,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $values;
    }
}
