<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * BSS Commerce does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * BSS Commerce does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   BSS
 * @package    Bss_PreviousNextProduct
 * @author     Extension Team
 * @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\PreviousNextProduct\Plugin;

use Magento\Catalog\Helper\Product\ProductList;
use Magento\Catalog\Model\Product\ProductList\Toolbar as ToolbarModel;
use Magento\Catalog\Block\Product\ProductList\Toolbar as ToolbarBlock;

class Toolbar
{
    const SORT_BY = 'bss_previous_next_product/general/sort_by';

    /**
     * @var string
     */
    protected $currentDirection;

    /**
     * @var array
     */
    protected $getCollection;

    /**
     * @var string
     */
    protected $ajaxData;

    /**
     * @var array
     */
    protected $collectionCloneTollbar;

    /**
     * @var array
     */
    protected $relevanceCollection;

    /**
     * @var array
     */
    protected $collectionClone;


    /**
     * Toolbar constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Bss\PreviousNextProduct\Block\PreviousNext $previousNextBlock
     * @param ToolbarBlock $toolbarBlock
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Bss\PreviousNextProduct\Block\PreviousNext $previousNextBlock,
        ToolbarBlock $toolbarBlock
    ) {
        $this->previousNextBlock = $previousNextBlock;
        $this->scopeConfig = $scopeConfig;
        $this->toolbarBlock = $toolbarBlock;
    }

    /**
     * @param ToolbarBlock $subject
     * @param \Magento\Framework\Data\Collection $collection
     */
    public function beforeSetCollection(\Magento\Catalog\Block\Product\ProductList\Toolbar $subject, \Magento\Framework\Data\Collection $collection)
    {
        if(!$this->ajaxData) {
            if ($this->collectionCloneTollbar === null) {
                $this->collectionCloneTollbar = clone $collection;
            }

            $collectionCloneTollbar = clone $this->collectionCloneTollbar;

            $this->collectionClone = $collectionCloneTollbar;
            $this->relevanceCollection = clone $collection;
            $this->relevanceCollection->setPageSize(100000);
        }
    }


    /**
     * set value sort order
     * @return string
     */
    public function setSortOrder()
    {
        switch ($this->getConfigSortOrder()) {
            case 'name':
                return 'name';
                break;
            case 'position':
                return 'position';
                break;
            case 'price':
                return 'price';
                break;
            case 'random':
                return $this->toolbarBlock->getCurrentOrder();
                break;
        }
    }

    /**
     * Get setting module sort orderby
     * @return string
     */
    public function getConfigSortOrder()
    {
        $values = $this->scopeConfig->getValue(
            self::SORT_BY,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        return $values;
    }

    /**
     * @param ToolbarBlock $subject
     * @param $result
     * @return mixed
     */
    public function afterGetCurrentDirection(\Magento\Catalog\Block\Product\ProductList\Toolbar $subject, $result)
    {
        $this->currentDirection = $result;
        return $result;
    }

    /**
     * @return null|string
     */
    public function getAjaxData()
    {
        if ($this->collectionClone) {
            if (!$this->currentDirection) {
                $this->currentDirection = $this->toolbarBlock->getCurrentDirection();
            }
            if ($this->setSortOrder()) {
                if ($this->setSortOrder() == 'position') {
                    if ($this->previousNextBlock->getTypePage() !== "catalogsearch_result_index") {
                        $this->collectionClone->addAttributeToSort(
                            $this->setSortOrder(),
                            'desc'
                        )->addAttributeToSort('entity_id', 'desc');
                    } elseif ($this->previousNextBlock->getTypePage() == "catalogsearch_result_index") {
                        $this->relevanceCollection->addAttributeToSort(
                            'relevance',
                            $this->currentDirection
                        );
                        $getCollection = $this->relevanceCollection->getData();
                        $ajaxData = null;
                        foreach ($getCollection as $product) {
                            $ajaxData = $ajaxData.$product["entity_id"].",";
                        }
                        $this->ajaxData = $ajaxData;
                        return $this->ajaxData;
                    }
                } else {
                    if ($this->setSortOrder() == 'price') {
                        $this->collectionClone->setOrder($this->setSortOrder(), $this->currentDirection)->addAttributeToSort('entity_id', 'desc');
                    } else {
                        $this->collectionClone->setOrder($this->setSortOrder(), $this->currentDirection);
                    }
                }
            }

            $getCollection = $this->collectionClone->getData();
            $ajaxData = null;
            foreach ($getCollection as $product) {
                $ajaxData = $ajaxData.$product["entity_id"].",";
            }
            $this->ajaxData = $ajaxData;
            return $this->ajaxData;
        } else {
            return null;
        }
    }
}
