<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * =================================================================
 *                 MAGENTO EDITION USAGE NOTICE
 * =================================================================
 * This package designed for Magento COMMUNITY edition
 * BSS Commerce does not guarantee correct work of this extension
 * on any other Magento edition except Magento COMMUNITY edition.
 * BSS Commerce does not provide extension support in case of
 * incorrect edition usage.
 * =================================================================
 *
 * @category   BSS
 * @package    Bss_PreviousNextProduct
 * @author     Extension Team
 * @copyright  Copyright (c) 2015-2016 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\PreviousNextProduct\Block;

class PreviousNext extends \Magento\Framework\View\Element\Template
{

    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $productCollectionFactory;

    /**
     * @var \Magento\Catalog\Model\ProductRepository
     */
    protected $productRepository;

    /**
     * @var int
     */
    protected $storeId;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Magento\Catalog\Model\Layer\CategoryFactory
     */
    protected $categoryFactory;

    /**
     * PreviousNext constructor.
     * @param \Magento\Catalog\Block\Product\Context $context
     * @param \Magento\Catalog\Model\CategoryFactory $categoryFactory
     * @param \Magento\Framework\App\Request\Http $request
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
     * @param \Magento\Catalog\Model\ProductRepository $productRepository
     * @param \Bss\PreviousNextProduct\Helper\Data $helper
     * @param \Magento\Catalog\Model\Layer\CategoryFactory $layerCategory
     * @param array $data
     */
    public function __construct(
        \Magento\Catalog\Block\Product\Context $context,
        \Magento\Catalog\Model\CategoryFactory $categoryFactory,
        \Magento\Framework\App\Request\Http $request,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Bss\PreviousNextProduct\Helper\Data $helper,
        \Magento\Catalog\Model\Layer\CategoryFactory $layerCategory,
        array $data = []
    ) {
        $this->layerCategory = $layerCategory;
        $this->request = $request;
        $this->registry = $context->getRegistry();
        $this->categoryFactory = $categoryFactory;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->productRepository = $productRepository;
        $this->helper = $helper;
        parent::__construct(
            $context,
            $data
        );
    }

    /**
     * @return \Magento\Catalog\Model\ResourceModel\Product\Collection
     */
    public function getCategoryFactory()
    {
        $filter = $this->layerCategory->create();
        $collection = $filter->getProductCollection();
        $collection->getData();
        return $collection;
    }

    /**
     * @return \Bss\PreviousNextProduct\Helper\Data
     */
    public function getHelper()
    {
        return $this->helper;
    }

    /**
     * @return string
     */
    public function setFontSize()
    {
        $size = (int)$this->getHelper()->setWidthPopup();
        $size  /=  10;
        return $size.'px';
    }

    /**
     * @param $categoryId
     * @return \Magento\Catalog\Model\ResourceModel\Product\Collection
     */
    public function getProductCollection($categoryId)
    {
        $category = $this->categoryFactory->create()->load($categoryId);
        $collection = $this->productCollectionFactory->create();
        $collection->addAttributeToSelect('*');
        $collection->addCategoryFilter($category);
        $collection->addAttributeToFilter('visibility', \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH);
        $rulerStatus = \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED;
        $collection->addAttributeToFilter('status', $rulerStatus);
        $collection->addFieldToFilter([['attribute'=>'visibility', 'neq'=>"1" ]]);
        $collection->addUrlRewrite();
        return $collection;
    }

    /**
     * @return string
     */
    public function getAjaxUrl()
    {
        return $this->getUrl('previousnextproduct/index/checkurl');
    }

    /**
     * @return string
     */
    public function getDeleteSessionUrl()
    {
        return $this->getUrl('previousnextproduct/index/deletesession');
    }

    /**
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->getUrl();
    }

    /**
     * Get current product
     * @return Product
     */
    public function getCurrentProduct()
    {
        $currentProduct = $this->registry->registry('current_product');
        return $currentProduct;
    }

    /**
     * @return string
     */
    public function getTypePage()
    {
        return $this->request->getFullActionName();
    }

    /**
     * Get current product
     * @return Product
     */
    public function getCurrentCategory()
    {
        $currentProduct = $this->registry->registry('current_category');
        return $currentProduct;
    }

    /**
     * get url product
     * @return string
     */
    public function getUrlProduct($idProduct)
    {
        $product = $this->productRepository->getById($idProduct);
        return $product->getUrlModel()->getUrl($product);
    }

    /**
     * exist product in collection
     * @return boolean
     */
    public function existProductInCollection()
    {
        $collection = clone $this->getCurrentProductCollection();
        foreach ($collection as $key => $value) {
            if ($value->getId() == $this->getCurrentProduct()->getId()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Get category
     * @return category
     */
    public function getCategory($categoryId)
    {
        $category = $this->categoryFactory->create();
        $category->load($categoryId);
        return $category;
    }

    /**
     * cut text length
     * @return string
     */
    public function cuttingTextLength($str)
    {
        $length = $this->getConfigTextLength();
        if (!settype($length, 'int') || $length == null) {
            return $str;
        }
        $str = substr($str, 0, $length);
        $str = $str."...";
        return $str;
    }
}
