<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\Model\Config\Backend;

class CheckFontSizeNumber extends \Magento\Framework\App\Config\Value
{
    /**
     * Plugin before Save
     *
     * @return $this
     * @throws \Magento\Framework\Exception\ValidatorException
     */
    public function beforeSave()
    {

        if (!is_numeric($this->getValue())) {
            throw new \Magento\Framework\Exception\ValidatorException(__('Font Size is not a number.'));
        } elseif ((int)$this->getValue() < 0) {
            throw new \Magento\Framework\Exception\ValidatorException(__(
                'Font Size must be greater than zero.'));
        }

        $this->setValue(intval($this->getValue()));

        return parent::beforeSave();
    }
}