<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\Model\Config\Backend;

class ArraySerialized extends \Magento\Config\Model\Config\Backend\Serialized\ArraySerialized
{

    /**
     * ArraySerialized constructor.
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $config
     * @param \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Config\ScopeConfigInterface $config,
        \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct($context, $registry, $config, $cacheTypeList, $resource, $resourceCollection, $data);
    }

    /**
     * @throws \Magento\Framework\Exception\ValidatorException
     * @return void
     */
    public function beforeSave()
    {
        $values = $this->getValue();
        $groupId = [];
        if (is_array($values)) {
            foreach ($values as $value) {
                if (is_array($value)) {
                    $groupId[] = $value['customer_group'];
                    $threshold = (float) $value['threshold'];
                    if ($threshold < 0) {
                        throw new \Magento\Framework\Exception\ValidatorException(__('Threshold must be positive'));
                        break;
                    }
                }
            }
        }
        $countGroupId = count($groupId);
        for ($i = 0; $i < $countGroupId-1; $i++) {
            $check = $groupId[$i];
            for ($j = $i+1; $j < $countGroupId; $j++) {
                if ($check == $groupId[$j]) {
                    throw new \Magento\Framework\Exception\ValidatorException(
                        __('You only can create one rule per one customer group')
                    );
                    break;
                }
            }
        }

        parent::beforeSave();
    }
}
