<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\Helper;

use \Magento\Framework\Serialize\Serializer\Json;
use phpDocumentor\Reflection\Types\Array_;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    protected $date;

    /**
     * @var \Magento\Framework\Filesystem
     */
    protected $filesystem ;

    /**
     * @var \Magento\Framework\App\ProductMetadata
     */
    protected $productMetadata;

    /**
     * @var Json
     */
    protected $json;

    /**
     * @var \Magento\Framework\Pricing\PriceCurrencyInterface
     */
    protected $priceCurrency;

    /**
     * @var \Magento\Directory\Model\Currency
     */
    protected $currency;

    /**
     * Data constructor.
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     * @param \Magento\Framework\Filesystem $filesystem
     * @param \Magento\Framework\App\ProductMetadata $productMetadata
     * @param Json $json
     * @param \Magento\Directory\Model\Currency $currency
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\App\ProductMetadata $productMetadata,
        Json $json,
        \Magento\Framework\Pricing\PriceCurrencyInterface $priceCurrency,
        \Magento\Directory\Model\Currency $currency
    ) {
    
        $this->storeManager = $storeManager;
        $this->date = $date;
        $this->filesystem = $filesystem;
        $this->productMetadata = $productMetadata;
        $this->json = $json;
        $this->priceCurrency = $priceCurrency;
        $this->currency = $currency;
        parent::__construct($context);
    }

    /**
     * Get Store.
     *
     * @return \Magento\Store\Api\Data\StoreInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getStore()
    {
        return $this->storeManager->getStore();
    }

    /**
     * @return \Magento\Framework\Pricing\PriceCurrencyInterface
     */
    public function getPriceCurrency()
    {
        return $this->priceCurrency;
    }

    /**
     * @return \Magento\Directory\Model\Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @return bool
     */
    public function isEnable()
    {
        return $this->scopeConfig->isSetFlag(
            'freeshippingbar/general/enable',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getSuccessMessage()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/general/success_message',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getLayoutPosition()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/general/layout_position',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return array
     */
    public function getThreshold()
    {
        $arr = [];
        $tableConfig = $this->scopeConfig->getValue(
            'freeshippingbar/general/free_shipping_threshold',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
        if ($tableConfig) {
            if (version_compare($this->productMetadata->getVersion(), '2.2.0', '>')) {
                $tableConfigResults = $this->json->unserialize($tableConfig);
            } else {
                $tableConfigResults = unserialize($tableConfig);
            }
            if (is_array($tableConfigResults)) {
                $i=0;
                foreach ($tableConfigResults as $tableConfigResult) {
                    $arr[$i]['customer_group'] = $tableConfigResult['customer_group'];
                    $arr[$i]['threshold'] = $tableConfigResult['threshold'];
                    $arr[$i]['message'] = $tableConfigResult['message'];
                    $i++;
                }
            }
        }
        return $arr;
    }

    /**
     * @return string
     */
    public function getTextColor()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/text_color',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getValueColor()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/value_color',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getBackgroundColor()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/background_color',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getFontSize()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/font_size',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getTextAlign()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/text_align',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getAutoHide()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/general/auto_hide',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return bool
     */
    public function isAllowClose()
    {
        return $this->scopeConfig->isSetFlag(
            'freeshippingbar/general/allow_close',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function isStick()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/general/sticker',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getCustomCss()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/custom_css',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getFontFamily()
    {
        return $this->scopeConfig->getValue(
            'freeshippingbar/design/font_type',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return bool
     */
    public function isIncludeTax()
    {
        return $this->scopeConfig->isSetFlag(
            'freeshippingbar/general/is_include_tax',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
}
