<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\Block;

use Magento\Framework\View\Element\Template;

class FreeShippingBar extends Template
{
    /**
     * Font type for shipping bar
     */
    const FONT_OPEN_SANS = 0;
    const FONT_LATO = 1;
    const FONT_OLD_STANDARD_TT = 2;
    const FONT_ABRIL_FATFACE = 3;
    const FONT_PT_SERIF = 4;
    const FONT_UBUNTU = 5;
    const FONT_VOLLKORN = 6;
    const FONT_DROID = 7;

    /**
     * @var \Bss\FreeShippingBar\Helper\Data
     */
    protected $helper;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * FreeShippingBar constructor.
     * @param Template\Context $context
     * @param \Bss\FreeShippingBar\Helper\Data $helper
     * @param \Magento\Customer\Model\Session $customerSession
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        \Bss\FreeShippingBar\Helper\Data $helper,
        \Magento\Customer\Model\Session $customerSession,
        array $data = []
    ) {

        parent::__construct($context, $data);
        $this->helper=$helper;
        $this->customerSession = $customerSession;
    }

    /**
     * @return mixed
     */
    public function getThreshold()
    {
        return $this->helper->getThreshold();
    }

    /**
     * @return mixed
     */
    public function getLayoutPosition()
    {
        return $this->helper->getLayoutPosition();
    }

    /**
     * @return bool
     */
    public function isCustomerLoggedIn()
    {
        return $this->customerSession->isLoggedIn();
    }

    /**
     * @return mixed
     */
    public function isStick()
    {
        return $this->helper->isStick();
    }

    /**
     * @return int
     */
    public function getCustomerGroup()
    {
        return $this->customerSession->getCustomerGroupId();
    }

    /**
     * @return bool
     */
    public function checkCustomerGroup()
    {
        $thresholds=$this->getThreshold();
        if (is_array($thresholds)) {
            foreach ($thresholds as $threshold) {
                if ($threshold['customer_group'] == $this->getCustomerGroup()) {
                    return $threshold;
                }
            }
        }
        return false;
    }

    /**
     * @return bool
     */
    public function addMessage()
    {
        if ($this->helper->isEnable() && $this->checkCustomerGroup()) {
            return true;
        }
        return false;
    }

    /**
     * @return mixed
     */
    public function getAutoHide()
    {
        return $this->helper->getAutoHide();
    }

    /**
     * @return bool
     */
    public function isAllowClose()
    {
        return $this->helper->isAllowClose();
    }

    /**
     * @return mixed
     */
    public function getCustomCss()
    {
        return $this->helper->getCustomCss();
    }

    /**
     * @return string
     */
    public function getFontFamily()
    {
        switch ($this->helper->getFontFamily()) {
            case self::FONT_OPEN_SANS:
                return "Open Sans";
            case self::FONT_LATO:
                return 'Lato';
            case self::FONT_OLD_STANDARD_TT:
                return 'Old Standard TT';
            case self::FONT_ABRIL_FATFACE:
                return 'Abril Fatface';
            case self::FONT_PT_SERIF:
                return 'PT Serif';
            case self::FONT_UBUNTU:
                return 'Ubuntu';
            case self::FONT_VOLLKORN:
                return 'Vollkorn';
            case self::FONT_DROID:
                return 'Droid';
            default:
                return 'Open Sans';
        }
    }

    /**
     * @return string
     */
    public function getStyle()
    {
        $style="style=\"padding:10px; background: greenyellow".
            ";font-family:".$this->getFontFamily().
            ";background:".$this->helper->getBackgroundColor().
            ";color:".$this->helper->getTextColor().
            ";font-size:".$this->helper->getFontSize()."px".
            ";text-align:".$this->helper->getTextAlign().
            ";".$this->getCustomCss()."\"";
        return $style;
    }
}
