define([
    'jquery',
    'Magento_Customer/js/customer-data'
], function ($, customerData) {
    'use strict';
    return function (widget) {

        $.widget('mage.sidebar', widget, {

            _create: function () {
                this._super();
                var data = customerData.get('cart')();
                var message = data.message_free_shipping;
                $('.free-shipping-bar#mess').html(message);
                $('.free-shipping-bar').css('display', 'block');
            },

            update: function () {
                this._super();
                var data = customerData.get('cart')();
                var message = data.message_free_shipping;
                if ($('.free-shipping-bar#mess').html !== message) {
                    $('.free-shipping-bar#mess').html(message);
                    $('.free-shipping-bar').css('display', 'block');
                }
            },
        });

        return $.mage.sidebar;
    }
});
