<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\CustomerData;

use Magento\Checkout\CustomerData\Cart as CartData;

class Cart
{

    /**
     * @var \Bss\FreeShippingBar\Helper\FreeShippingBar
     */
    private $freeShippingMessage;

    /**
     * Cart constructor.
     * @param \Bss\FreeShippingBar\Helper\FreeShippingBar $freeShippingMessage
     */
    public function __construct(\Bss\FreeShippingBar\Helper\FreeShippingBar $freeShippingMessage)
    {
        $this->freeShippingMessage = $freeShippingMessage;
    }

    /**
     * After Get Section Data
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @param CartData $subject
     * @param $result
     * @return mixed
     */
    public function afterGetSectionData(CartData $subject, $result)
    {
        $result['message_free_shipping'] = $this->freeShippingMessage->getMessage($result);
        return $result;
    }
}
