<?php
/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
namespace Bss\FreeShippingBar\Controller\Index;

use Magento\Framework\App\Action\Context;

class Index extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $cart;

    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $resultJsonFactory;

    /**
     * @var \Bss\FreeShippingBar\Helper\Data
     */
    protected $helper;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Magento\Directory\Model\Currency
     */
    protected $currency;

    /**
     * @var \Magento\Framework\Pricing\PriceCurrencyInterface
     */
    protected $priceCurrency;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * Index constructor.
     * @param Context $context
     * @param \Magento\Checkout\Model\Cart $cart
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
     * @param \Bss\FreeShippingBar\Helper\Data $helper
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Directory\Model\Currency $currency
     * @param \Magento\Framework\Pricing\PriceCurrencyInterface $priceCurrency
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        \Magento\Checkout\Model\Cart $cart,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Bss\FreeShippingBar\Helper\Data $helper,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Directory\Model\Currency $currency,
        \Magento\Framework\Pricing\PriceCurrencyInterface $priceCurrency,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->cart = $cart;
        $this->resultJsonFactory=$resultJsonFactory;
        $this->helper = $helper;
        $this->customerSession = $customerSession;
        $this->currency = $currency;
        $this->priceCurrency = $priceCurrency;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     * @return $this
     */
    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        return $result->setData($this->getMessage());
    }

    /**
     * @return float
     */
    protected function getCartSubtotal()
    {
        $total = $this->cart->getQuote()->getTotals();
        $subtotal = $total['subtotal']->getData();
        if (isset($subtotal['value_incl_tax']) && isset($subtotal['value_excl_tax'])) {
            if ($this->helper->isIncludeTax()) {
                return (float)$subtotal['value_incl_tax'];
            }
            return (float)$subtotal['value_excl_tax'];
        }
        return $this->cart->getQuote()->getSubtotal();
    }

    /**
     * @return \Magento\Framework\Phrase|string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getMessage()
    {
        $message = "";
        if ($this->helper->isEnable()) {
            if ($this->checkCustomerGroup()) {
                $rate = (float)$this->storeManager->getStore()->getCurrentCurrencyRate();
                $symbol = $this->priceCurrency->getCurrency()->getCurrencySymbol();
                $threshold = $this->checkCustomerGroup();
                $thresholdValue = (float)$rate * $threshold['threshold'];
                $cartSubtotal = (float)$this->getCartSubtotal();
                if ($thresholdValue > $cartSubtotal) {
                    $leftValue = $thresholdValue - $cartSubtotal;
                    $thresholdValue = $this->currency->formatTxt($thresholdValue, ['display' => $symbol]);
                    $leftValue = $this->currency->formatTxt($leftValue, ['display' => $symbol]);
                    $cartSubtotal = $this->currency->formatTxt($cartSubtotal, ['display' => $symbol]);
                    $message = str_replace(
                        "{thresholdValue}",
                        "<em style='color:" . $this->helper->getValueColor() . "'>" . $thresholdValue . "</em>",
                        $threshold['message']
                    );
                    $message = str_replace(
                        "{leftValue}",
                        "<em style='color:" . $this->helper->getValueColor() . "'>" . $leftValue . "</em>",
                        $message
                    );
                    $message = str_replace(
                        "{cartSubtotal}",
                        "<em style='color:" . $this->helper->getValueColor() . "'>" . $cartSubtotal . "</em>",
                        $message
                    );
                } else {
                    $message = $this->helper->getSuccessMessage();
                }
            }
            return __($message);
        }
        return "";
    }

    /**
     * @return int
     */
    protected function getCustomerGroup()
    {
        if ($this->isCustomerLoggedIn()) {
            return $this->customerSession->getCustomer()->getGroupId();
        }
        return 0;
    }

    /**
     * @return bool
     */
    protected function checkCustomerGroup()
    {
        $thresholds = $this->getThreshold();
        foreach ($thresholds as $threshold) {
            if ($threshold['customer_group'] == $this->getCustomerGroup()) {
                return $threshold;
            }
        }
        return false;
    }

    /**
     * @return bool
     */
    protected function isCustomerLoggedIn()
    {
        return $this->customerSession->isLoggedIn();
    }

    /**
     * @return numeric
     */
    protected function getThreshold()
    {
        return $this->helper->getThreshold();
    }
}
