define([
    'jquery',
    'ko',
    'uiComponent',
    'Magento_Customer/js/customer-data',
], function ($, ko, Component, customerData) {
    'use strict';

    return Component.extend({
        initialize: function () {
            this._super();
            this.cart = customerData.get('cart');
        },
        getMessage: function() {
            customerData.reload('cart');
            var data = customerData.get('cart')();
            var message = data.message_free_shipping;
            if (message === undefined) {
                $(document).on('ajaxComplete', function (event, xhr, settings) {
                    var data = customerData.get('cart')();
                    message = data.message_free_shipping;
                });
            }
            return message;
        }
    });
});
