/**
 * BSS Commerce Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://bsscommerce.com/Bss-Commerce-License.txt
 *
 * @category   BSS
 * @package    Bss_FreeShippingBar
 * @author     Extension Team
 * @copyright  Copyright (c) 2017-2018 BSS Commerce Co. ( http://bsscommerce.com )
 * @license    http://bsscommerce.com/Bss-Commerce-License.txt
 */
define([
    "jquery",
    'Magento_Customer/js/customer-data'
], function ($, customerData) {
    "use strict";
    $.widget('message.ajax', {
        _create: function () {
            $(document).ready(function () {
                customerData.reload('cart');
                var data = customerData.get('cart')();
                var message = data.message_free_shipping;
                if (message === undefined) {
                    $(document).on('ajaxComplete', function (event, xhr, settings) {
                        var data = customerData.get('cart')();
                        var message = data.message_free_shipping;
                        $('.free-shipping-bar#mess').html(message);
                    });
                } else {
                    $('.free-shipping-bar#mess').html(message);
                }
            });

        },
    });

    var column = $(".free-shipping-bar").parent();
    $(document).ready(function () {
        $(".free-shipping-bar").width(column.width()-20);
        $('.free-shipping-bar').css('margin','auto');

        if ($('.layout-position').val()=='top-page') {
            $(".free-shipping-bar").appendTo(".page-header");
        } else {
            $(".free-shipping-bar").prependTo(".page-main"); }
        var time=$('.auto-hide').val();
        if (time>0) {
            setTimeout(function () {
                $('.free-shipping-bar').css('display', 'none')
            }, time * 1000);
        }

    });

    $(window).resize(function () {
        $(".free-shipping-bar").width(column.width()-20);
        $('.free-shipping-bar').css('margin','auto');
    });

    $('#close').click(function () {
        $('.free-shipping-bar').css('display','none');
    });

    $(window).scroll(function () {
        if ($('.sticker').val()==1) {
            var left=($(window).width()-$(".free-shipping-bar").width())/2-10;
            if ($(this).scrollTop() != 0) {
                $('.free-shipping-bar').css('position', 'fixed');
                $('.free-shipping-bar').css('top', '0px');
                $('.free-shipping-bar').css('z-index', '100');
                $('.free-shipping-bar').css('left',left);
            } else {
                $('.free-shipping-bar').css('top','');
                $('.free-shipping-bar').css('left','');
                $('.free-shipping-bar').css('position','');
            }
        }
    });

    return $.message.ajax;
});
